# Kubernetes Python API Project

This project sets up a replicable environment for students to develop a Python software API and backend, connected to a MySQL database. The environment can be deployed for a computer science final exam and deleted afterward.

## Project Structure

```
kubernetes-python-api
├── k8s
│   ├── deployments
│   │   ├── api-deployment.yaml
│   │   └── mysql-deployment.yaml
│   ├── services
│   │   ├── api-service.yaml
│   │   └── mysql-service.yaml
│   └── configmaps
│       └── mysql-configmap.yaml
├── src
│   ├── api
│   │   ├── app.py
│   │   └── requirements.txt
│   └── db
│       └── init.sql
├── .gitignore
├── Dockerfile
├── README.md
└── setup.sh
```

## Setup Instructions

1. **Clone the Repository**
   Clone this repository to your local machine.

   ```
   git clone <repository-url>
   cd kubernetes-python-api
   ```

2. **Build the Docker Image**
   Build the Docker image for the Python API.

   ```
   docker build -t python-api .
   ```

3. **Deploy to Kubernetes**
   Use the provided `setup.sh` script to deploy the environment.

   ```
   ./setup.sh
   ```

4. **Access the API**
   Once the deployment is complete, access the API using the service defined in `k8s/services/api-service.yaml`.

5. **Cleanup**
   After the exam, run the cleanup command to delete the environment.

   ```
   kubectl delete -f k8s/
   ```

## Usage

- The Python API is built using Flask or FastAPI and connects to a MySQL database.
- Students can modify the API code in `src/api/app.py` and the database schema in `src/db/init.sql`.

## Notes

- Ensure that you have Kubernetes and Docker installed on your machine.
- Modify the environment variables in the deployment YAML files as needed for your specific use case.