from flask import Flask, render_template, request
from kubernetes import client, config
import os
import git
import yaml

app = Flask(__name__)

# Load Kubernetes configuration
config.load_incluster_config()

# Default route
@app.route('/')
def index():
    return render_template('index.html')

# Route to create a new environment
@app.route('/create_environment', methods=['POST'])
def create_environment():
    niub = request.form['niub']
    namespace = f"student{niub}"

    # Create namespace
    v1 = client.CoreV1Api()
    namespace_body = client.V1Namespace(
        metadata=client.V1ObjectMeta(name=namespace)
    )
    try:
        v1.create_namespace(namespace_body)
    except client.exceptions.ApiException as e:
        if e.status == 409:
            return f"Namespace {namespace} already exists.", 409
        else:
            raise e

    # Apply PersistentVolumeClaim for API
    with open(os.path.join('k8s', 'deployments', 'api-pvc.yaml')) as f:
        pvc_data = yaml.safe_load(f)
        pvc = client.V1PersistentVolumeClaim(
            api_version=pvc_data['apiVersion'],
            kind=pvc_data['kind'],
            metadata=pvc_data['metadata'],
            spec=pvc_data['spec']
        )
        v1.create_namespaced_persistent_volume_claim(namespace=namespace, body=pvc)

    # Clone the base git repository of the app to the PVC mount path
    repo_url = "https://tfg-arnau-cirera:Ej3Xfw8Fa@gitlab.com/ArnolSwet/base_exam_uc1_tfg.git"
    """ repo_path = f"/mnt/{namespace}/app"
    os.makedirs(repo_path, exist_ok=True)
    """ 
    try:
        repo = git.Repo.clone_from(repo_url,'./base_exam_uc1_tfg')
    except git.exc.GitCommandError as e:
        if 'already exists' in str(e):
            repo = git.Repo('./base_exam_uc1_tfg')
            repo.git.pull() 
            """
        else:
            raise e """
    new_branch = repo.create_head(niub)
    repo.head.reference = new_branch
    repo.head.reset(index=True, working_tree=True)
    repo.git.push("origin", new_branch)

    # Apply MySQL Secret
    with open(os.path.join('k8s', 'configmaps', 'mysql-secret.yaml')) as f:
        secret_data = yaml.safe_load(f)
        secret = client.V1Secret(
            api_version=secret_data['apiVersion'],
            kind=secret_data['kind'],
            metadata=secret_data['metadata'],
            data=secret_data['data']
        )
        v1.create_namespaced_secret(namespace=namespace, body=secret)

    # Apply MySQL ConfigMap
    with open(os.path.join('k8s', 'configmaps', 'mysql-configmap.yaml')) as f:
        configmap_data = yaml.safe_load(f)
        configmap = client.V1ConfigMap(
            api_version=configmap_data['apiVersion'],
            kind=configmap_data['kind'],
            metadata=configmap_data['metadata'],
            data=configmap_data['data']
        )
        v1.create_namespaced_config_map(namespace=namespace, body=configmap)

    # Apply MySQL Deployment
    apps_v1 = client.AppsV1Api()
    with open(os.path.join('k8s', 'deployments', 'mysql-deployment.yaml')) as f:
        mysql_deployment_data = yaml.safe_load(f)
        mysql_deployment = client.V1Deployment(
            api_version=mysql_deployment_data['apiVersion'],
            kind=mysql_deployment_data['kind'],
            metadata=mysql_deployment_data['metadata'],
            spec=mysql_deployment_data['spec']
        )
        apps_v1.create_namespaced_deployment(namespace=namespace, body=mysql_deployment)

    # Apply API Deployment
    with open(os.path.join('k8s', 'deployments', 'api-deployment.yaml')) as f:
        api_deployment_data = yaml.safe_load(f)
        api_deployment = client.V1Deployment(
            api_version=api_deployment_data['apiVersion'],
            kind=api_deployment_data['kind'],
            metadata=api_deployment_data['metadata'],
            spec=api_deployment_data['spec']
        )
        apps_v1.create_namespaced_deployment(namespace=namespace, body=api_deployment)

    # Apply MySQL Service
    with open(os.path.join('k8s', 'services', 'mysql-service.yaml')) as f:
        mysql_service_data = yaml.safe_load(f)
        mysql_service = client.V1Service(
            api_version=mysql_service_data['apiVersion'],
            kind=mysql_service_data['kind'],
            metadata=mysql_service_data['metadata'],
            spec=mysql_service_data['spec']
        )
        v1.create_namespaced_service(namespace=namespace, body=mysql_service)

    # Apply API Service
    with open(os.path.join('k8s', 'services', 'api-service.yaml')) as f:
        api_service_data = yaml.safe_load(f)
        api_service = client.V1Service(
            api_version=api_service_data['apiVersion'],
            kind=api_service_data['kind'],
            metadata=api_service_data['metadata'],
            spec=api_service_data['spec']
        )
        v1.create_namespaced_service(namespace=namespace, body=api_service)

    return render_template('instructions.html', niub=niub, namespace=namespace)

# Route to delete an environment
@app.route('/delete_environment', methods=['POST'])
def delete_environment():
    niub = request.form['niub']
    namespace = f"student{niub}"

    # Delete namespace
    v1 = client.CoreV1Api()
    try:
        v1.delete_namespace(name=namespace)
    except client.exceptions.ApiException as e:
        if e.status == 404:
            return f"El Namespace {namespace} no existeix.", 404
        else:
            raise e

    return render_template('delete_success.html', niub=niub, namespace=namespace)

if __name__ == '__main__':
    app.run(host='0.0.0.0', port=5000)