#!/bin/bash

# Check if NIUB is provided
if [ -z "$1" ]; then
  echo "Usage: $0 <NIUB>"
  exit 1
fi

# Set the namespace for the Kubernetes resources
NIUB=$1
NAMESPACE="student$NIUB"

# Set the image name
IMAGE_NAME="student$NIUB"+"-api"

# Create the namespace
kubectl create namespace $NAMESPACE

# Apply the ConfigMap for MySQL
kubectl apply -f k8s/configmaps/mysql-configmap.yaml -n $NAMESPACE

# Deploy MySQL
kubectl apply -f k8s/deployments/mysql-deployment.yaml -n $NAMESPACE

# Build the Python API image
docker build -t arnaucirera98/student-api .
docker push arnaucirera98/student-api:latest

# Deploy the Python API
kubectl apply -f k8s/deployments/api-deployment.yaml -n $NAMESPACE

# Create services for MySQL and the Python API
kubectl apply -f k8s/services/mysql-service.yaml -n $NAMESPACE
kubectl apply -f k8s/services/api-service.yaml -n $NAMESPACE

echo "Kubernetes environment set up successfully in namespace '$NAMESPACE'."

# Uncomment the following line to enable deletion
# kubectl delete namespace $NAMESPACE --wait=true