#!/bin/bash

# Create the monitoring services

#Create the monitoring namespace
kubectl create namespace monitoring

#Deploy Prometheus stack with helm
# Add the prometheus-community helm repo
helm repo add prometheus-community https://prometheus-community.github.io/helm-charts
helm repo update
# Install the values.yaml file
helm upgrade --install -f k8s/deployments/prometheus-values.yaml kube-prometheus-stack prometheus-community/kube-prometheus-stack -n monitoring

# Create Control Panel

# Create main namespace
kubectl create namespace main

# Build and push control panel image
docker build -t arnaucirera98/control-panel ./control_panel
docker push arnaucirera98/control-panel:latest

# Create ServiceAccount, ClusterRole and ClusterRoleBinding for control panel
kubectl apply -f k8s/rbac/control-panel-rbac.yaml -n main

# Deploy control panel
kubectl apply -f k8s/deployments/control-panel-deployment.yaml -n main
kubectl apply -f k8s/services/control-panel-service.yaml -n main


