from flask import Flask, jsonify, request
import mysql.connector
import os

app = Flask(__name__)

def get_db_connection():
    connection = mysql.connector.connect(
        host=os.getenv('MYSQL_HOST'),
        user=os.getenv('MYSQL_USER'),
        password=os.getenv('MYSQL_PASSWORD'),
        database=os.getenv('MYSQL_DATABASE')
    )
    return connection

@app.route('/api/data', methods=['GET'])
def get_data():
    connection = get_db_connection()
    cursor = connection.cursor(dictionary=True)
    cursor.execute('SELECT * FROM your_table_name')  # Replace with your actual table name
    results = cursor.fetchall()
    cursor.close()
    connection.close()
    return jsonify(results)

@app.route('/api/data', methods=['POST'])
def create_data():
    new_data = request.json
    connection = get_db_connection()
    cursor = connection.cursor()
    cursor.execute('INSERT INTO your_table_name (column1, column2) VALUES (%s, %s)', 
                   (new_data['column1'], new_data['column2']))  # Replace with your actual columns
    connection.commit()
    cursor.close()
    connection.close()
    return jsonify(new_data), 201

if __name__ == '__main__':
    app.run(host='0.0.0.0', port=5000)