#!/bin/bash

# Create the monitoring services

#Create the monitoring namespace
kubectl create namespace monitoring

#Deploy Prometheus stack with helm
# Add the prometheus-community helm repo
helm repo add prometheus-community https://prometheus-community.github.io/helm-charts
helm repo update
# Install the values.yaml file
helm upgrade --install -f k8s/deployments/prometheus-values.yaml kube-prometheus-stack prometheus-community/kube-prometheus-stack -n monitoring

# Create Catalog

# Create main namespace
kubectl create namespace main

# Build and push catalog image
docker build -t arnaucirera98/catalog ./catalog
docker push arnaucirera98/catalog:latest

# Deploy mysql database
kubectl apply -f k8s/configs/mysql-config.yaml -n main
kubectl apply-f k8s/configs/mysql-secret.yaml -n main
kubectl apply -f k8s/deployments/mysql-deployment.yaml -n main
kubectl apply -f k8s/services/mysql-service.yaml -n main


# Deploy control panel
kubectl apply -f k8s/deployments/catalog-deployment.yaml -n main
kubectl apply -f k8s/services/catalog-service.yaml -n main

