__all__ = ["getDriver"]

def getDriver(driverNumber):
    """
    Returns the driver name for a given Formula 1 car number.

    Parameters:
        driverNumber (int): The car number of the F1 driver.

    Returns:
        str: The name of the driver. Defaults to Max Verstappen (car number 1) if number is not recognized.
    """
    
    data = {
        1: "Max Verstappen",
        4: "Lando Norris",
        5: "Gabriel Bortoleto",
        6: "Isack Hadjar",
        7: "Jack Doohan",
        10: "Pierre Gasly",
        12: "Andrea Kimi Antonelli",
        14: "Fernando Alonso",
        16: "Charles Leclerc",
        18: "Lance Stroll",
        22: "Yuki Tsunoda",
        23: "Alexander Albon",
        27: "Nico Hülkenberg",
        30: "Liam Lawson",
        31: "Esteban Ocon",
        43: "Franco Colapinto",
        44: "Lewis Hamilton",
        55: "Carlos Sainz Jr.",
        63: "George Russell",
        81: "Oscar Piastri",
        87: "Oliver Bearman"
    }

    return data.get(driverNumber, "Max Verstappen")