__all__ = ["getRaceData"]

def getRaceData(city):
    """
    Retrieves structured race data for a given Formula 1 city.

    This function returns metadata and qualifying session data for a specified city.
    If the provided city is not found in the internal data dictionary, it defaults to "Melbourne".

    Parameters:
        city (str): The name of the city for which to retrieve race data (e.g., "Melbourne", "Shanghai").

    Returns:
        tuple: A tuple containing the following elements:
            - list: [
                outputFileName (str): Path to the TFRecord output file,
                dataTable (str): Name of the race data table,
                lapsTable (str): Name of the laps data table,
                telemetryTable (str): Name of the telemetry data table,
                year (int): The year of the race,
                roundNumber (int): Round number in the season,
                city (str): Name of the city,
                session (int): Session ID,
                qualifyingData (dict): Qualifying results by driver number,
                raceStartTime (str): ISO timestamp of race start time
              ]
            - int: Year of the race.
            - int: Round number of the race.
            - str: ISO timestamp of the race start time.
            - int: Number of race laps.
            - str: Output file name for storing TFRecord data.
    """
    
    data = {
        "Melbourne": {
            "outputFileName": "../tfrecord/australia",
            "dataTable": "australia",
            "lapsTable": "australiaLaps",
            "telemetryTable": "australiaTelemetry",
            "year": 2025,
            "roundNumber": 1,
            "city": "Melbourne",
            "session": 9693,
            "qualifyingData": {
                "4": {"Q1": 75.912, "Q2": 75.415, "Q3": 75.096, "GridPosition": 1},
                "81": {"Q1": 76.062, "Q2": 75.468, "Q3": 75.180, "GridPosition": 2},
                "1": {"Q1": 76.018, "Q2": 75.565, "Q3": 75.481, "GridPosition": 3},
                "63": {"Q1": 75.971, "Q2": 75.798, "Q3": 75.546, "GridPosition": 4},
                "22": {"Q1": 76.225, "Q2": 76.009, "Q3": 75.670, "GridPosition": 5},
                "23": {"Q1": 76.245, "Q2": 76.017, "Q3": 75.737, "GridPosition": 6},
                "16": {"Q1": 76.029, "Q2": 75.827, "Q3": 75.755, "GridPosition": 7},
                "44": {"Q1": 76.213, "Q2": 75.919, "Q3": 75.973, "GridPosition": 8},
                "10": {"Q1": 76.328, "Q2": 76.112, "Q3": 75.980, "GridPosition": 9},
                "55": {"Q1": 76.360, "Q2": 75.931, "Q3": 76.062, "GridPosition": 10},
                "6": {"Q1": 76.354, "Q2": 76.175, "Q3": 99999.999, "GridPosition": 11},
                "14": {"Q1": 76.288, "Q2": 76.453, "Q3": 99999.999, "GridPosition": 12},
                "18": {"Q1": 76.369, "Q2": 76.483, "Q3": 99999.999, "GridPosition": 13},
                "7": {"Q1": 76.315, "Q2": 76.863, "Q3": 99999.999, "GridPosition": 14},
                "5": {"Q1": 76.516, "Q2": 77.520, "Q3": 99999.999, "GridPosition": 15},
                "12": {"Q1": 76.525, "Q2": 99999.999, "Q3": 99999.999, "GridPosition": 16},
                "27": {"Q1": 76.579, "Q2": 99999.999, "Q3": 99999.999, "GridPosition": 17},
                "30": {"Q1": 77.094, "Q2": 99999.999, "Q3": 99999.999, "GridPosition": 18},
                "31": {"Q1": 77.147, "Q2": 99999.999, "Q3": 99999.999, "GridPosition": 19},
                "87": {"Q1": 99999.999, "Q2": 99999.999, "Q3": 99999.999, "GridPosition": 20}
            },
            "raceStartTime": "2025-03-16T04:00:00+00:00",
            "raceLaps": 57
        },
        "Shanghai": {
            "outputFileName": "../tfrecord/china",
            "dataTable": "china",
            "lapsTable": "chinaLaps",
            "telemetryTable": "chinaTelemetry",
            "year": 2025,
            "roundNumber": 2,
            "city": "Shanghai",
            "session": 9998,
            "qualifyingData": {
                "81": {"Q1": 91.591, "Q2": 91.200, "Q3": 90.641, "GridPosition": 1},
                "63": {"Q1": 91.295, "Q2": 91.307, "Q3": 90.723, "GridPosition": 2},
                "4":  {"Q1": 90.983, "Q2": 90.787, "Q3": 90.793, "GridPosition": 3},
                "1":  {"Q1": 91.424, "Q2": 91.142, "Q3": 90.817, "GridPosition": 4},
                "44": {"Q1": 91.690, "Q2": 91.501, "Q3": 90.927, "GridPosition": 5},
                "16": {"Q1": 91.579, "Q2": 91.450, "Q3": 91.021, "GridPosition": 6},
                "6":  {"Q1": 91.162, "Q2": 91.253, "Q3": 91.079, "GridPosition": 7},
                "12": {"Q1": 91.676, "Q2": 91.590, "Q3": 91.103, "GridPosition": 8},
                "22": {"Q1": 91.238, "Q2": 91.260, "Q3": 91.638, "GridPosition": 9},
                "23": {"Q1": 91.503, "Q2": 91.595, "Q3": 91.706, "GridPosition": 10},
                "31": {"Q1": 91.876, "Q2": 91.625, "Q3": 99999.999, "GridPosition": 11},
                "27": {"Q1": 91.921, "Q2": 91.632, "Q3": 99999.999, "GridPosition": 12},
                "14": {"Q1": 91.719, "Q2": 91.688, "Q3": 99999.999, "GridPosition": 13},
                "18": {"Q1": 91.923, "Q2": 91.773, "Q3": 99999.999, "GridPosition": 14},
                "55": {"Q1": 91.628, "Q2": 91.840, "Q3": 99999.999, "GridPosition": 15},
                "10": {"Q1": 91.992, "Q2": 99999.999, "Q3": 99999.999, "GridPosition": 16},
                "87": {"Q1": 92.018, "Q2": 99999.999, "Q3": 99999.999, "GridPosition": 17},
                "7":  {"Q1": 92.092, "Q2": 99999.999, "Q3": 99999.999, "GridPosition": 18},
                "5":  {"Q1": 92.141, "Q2": 99999.999, "Q3": 99999.999, "GridPosition": 19},
                "30": {"Q1": 92.174, "Q2": 99999.999, "Q3": 99999.999, "GridPosition": 20}
            },
            "raceStartTime": "2025-03-23T07:00:00+00:00",
            "raceLaps": 56
        },
        "Suzuka": {
            "outputFileName": "../tfrecord/japan",
            "dataTable": "japan",
            "lapsTable": "japanLaps",
            "telemetryTable": "japanTelemetry",
            "year": 2025,
            "roundNumber": 3,
            "city": "Suzuka",
            "session": 10006,
            "qualifyingData": {
                "1": {"Q1": 87.943, "Q2": 87.502, "Q3": 86.983, "GridPosition": 1},
                "4": {"Q1": 87.845, "Q2": 87.146, "Q3": 86.995, "GridPosition": 2},
                "81": {"Q1": 87.687, "Q2": 87.507, "Q3": 87.027, "GridPosition": 3},
                "16": {"Q1": 87.920, "Q2": 87.555, "Q3": 87.299, "GridPosition": 4},
                "63": {"Q1": 87.843, "Q2": 87.400, "Q3": 87.318, "GridPosition": 5},
                "12": {"Q1": 87.968, "Q2": 87.639, "Q3": 87.555, "GridPosition": 6},
                "6": {"Q1": 88.278, "Q2": 87.775, "Q3": 87.569, "GridPosition": 7},
                "44": {"Q1": 87.942, "Q2": 87.610, "Q3": 87.610, "GridPosition": 8},
                "23": {"Q1": 88.218, "Q2": 87.783, "Q3": 87.615, "GridPosition": 9},
                "87": {"Q1": 88.228, "Q2": 87.711, "Q3": 87.867, "GridPosition": 10},
                "10": {"Q1": 88.186, "Q2": 87.822, "Q3": 99999.999, "GridPosition": 11},
                "55": {"Q1": 88.209, "Q2": 87.836, "Q3": 99999.999, "GridPosition": 12},
                "14": {"Q1": 88.337, "Q2": 87.897, "Q3": 99999.999, "GridPosition": 13},
                "30": {"Q1": 88.554, "Q2": 87.906, "Q3": 99999.999, "GridPosition": 14},
                "22": {"Q1": 87.967, "Q2": 88.000, "Q3": 99999.999, "GridPosition": 15},
                "27": {"Q1": 88.570, "Q2": 99999.999, "Q3": 99999.999, "GridPosition": 16},
                "5": {"Q1": 88.622, "Q2": 99999.999, "Q3": 99999.999, "GridPosition": 17},
                "31": {"Q1": 88.696, "Q2": 99999.999, "Q3": 99999.999, "GridPosition": 18},
                "7": {"Q1": 88.877, "Q2": 99999.999, "Q3": 99999.999, "GridPosition": 19},
                "18": {"Q1": 89.271, "Q2": 99999.999, "Q3": 99999.999, "GridPosition": 20}
            },
            "raceStartTime": "2025-04-06T05:00:00+00:00",
            "raceLaps": 53
        },
        "Sakhir": {
            "outputFileName": "../tfrecord/bahrain",
            "dataTable": "bahrain",
            "lapsTable": "bahrainLaps",
            "telemetryTable": "bahrainTelemetry",
            "year": 2025,
            "roundNumber": 4,
            "city": "Sakhir",
            "session": 10014,
            "qualifyingData": {
                "81": {"Q1": 91.392, "Q2": 90.454, "Q3": 89.841, "GridPosition": 1},
                "63": {"Q1": 91.494, "Q2": 90.664, "Q3": 90.009, "GridPosition": 2},
                "16": {"Q1": 91.454, "Q2": 90.724, "Q3": 90.175, "GridPosition": 3},
                "12": {"Q1": 91.415, "Q2": 90.716, "Q3": 90.213, "GridPosition": 4},
                "10": {"Q1": 91.462, "Q2": 90.643, "Q3": 90.216, "GridPosition": 5},
                "4": {"Q1": 91.107, "Q2": 90.560, "Q3": 90.267, "GridPosition": 6},
                "1": {"Q1": 91.303, "Q2": 91.019, "Q3": 90.423, "GridPosition": 7},
                "55": {"Q1": 91.591, "Q2": 90.844, "Q3": 90.680, "GridPosition": 8},
                "44": {"Q1": 91.219, "Q2": 91.009, "Q3": 90.772, "GridPosition": 9},
                "22": {"Q1": 91.751, "Q2": 91.228, "Q3": 91.303, "GridPosition": 10},
                "7": {"Q1": 91.414, "Q2": 91.245, "Q3": 99999.999, "GridPosition": 11},
                "6": {"Q1": 91.591, "Q2": 91.271, "Q3": 99999.999, "GridPosition": 12},
                "14": {"Q1": 91.634, "Q2": 91.886, "Q3": 99999.999, "GridPosition": 13},
                "31": {"Q1": 91.594, "Q2": 99999.999, "Q3": 99999.999, "GridPosition": 14},
                "23": {"Q1": 92.040, "Q2": 99999.999, "Q3": 99999.999, "GridPosition": 15},
                "27": {"Q1": 92.067, "Q2": 99999.999, "Q3": 99999.999, "GridPosition": 16},
                "30": {"Q1": 92.165, "Q2": 99999.999, "Q3": 99999.999, "GridPosition": 17},
                "5": {"Q1": 92.186, "Q2": 99999.999, "Q3": 99999.999, "GridPosition": 18},
                "18": {"Q1": 92.283, "Q2": 99999.999, "Q3": 99999.999, "GridPosition": 19},
                "87": {"Q1": 92.373, "Q2": 99999.999, "Q3": 99999.999, "GridPosition": 20}
            },
            "raceStartTime": "2025-04-13T15:00:00+00:00",
            "raceLaps": 57
        },
        "Jeddah": {
            "outputFileName": "../tfrecord/jeddah",
            "dataTable": "jeddah",
            "lapsTable": "jeddahLaps",
            "telemetryTable": "jeddahTelemetry",
            "year": 2025,
            "roundNumber": 5,
            "city": "Jeddah",
            "session": 10022,
            "qualifyingData": {
                "1": {"Q1": 87.778, "Q2": 87.529, "Q3": 87.294, "GridPosition": 1},
                "81": {"Q1": 87.901, "Q2": 87.545, "Q3": 87.304, "GridPosition": 2},
                "63": {"Q1": 88.282, "Q2": 87.599, "Q3": 87.407, "GridPosition": 3},
                "16": {"Q1": 88.552, "Q2": 87.866, "Q3": 87.670, "GridPosition": 4},
                "12": {"Q1": 88.128, "Q2": 87.798, "Q3": 87.866, "GridPosition": 5},
                "55": {"Q1": 88.354, "Q2": 88.024, "Q3": 88.164, "GridPosition": 6},
                "44": {"Q1": 88.372, "Q2": 88.102, "Q3": 88.201, "GridPosition": 7},
                "22": {"Q1": 88.226, "Q2": 87.990, "Q3": 88.204, "GridPosition": 8},
                "10": {"Q1": 88.421, "Q2": 88.025, "Q3": 88.367, "GridPosition": 9},
                "4": {"Q1": 87.805, "Q2": 87.481, "Q3": 99999.999, "GridPosition": 10},
                "23": {"Q1": 88.279, "Q2": 88.109, "Q3": 99999.999, "GridPosition": 11},
                "30": {"Q1": 88.561, "Q2": 88.191, "Q3": 99999.999, "GridPosition": 12},
                "14": {"Q1": 88.548, "Q2": 88.303, "Q3": 99999.999, "GridPosition": 13},
                "6": {"Q1": 88.571, "Q2": 88.418, "Q3": 99999.999, "GridPosition": 14},
                "87": {"Q1": 88.536, "Q2": 88.648, "Q3": 99999.999, "GridPosition": 15},
                "18": {"Q1": 88.645, "Q2": 99999.999, "Q3": 99999.999, "GridPosition": 16},
                "7": {"Q1": 88.739, "Q2": 99999.999, "Q3": 99999.999, "GridPosition": 17},
                "27": {"Q1": 88.782, "Q2": 99999.999, "Q3": 99999.999, "GridPosition": 18},
                "31": {"Q1": 89.092, "Q2": 99999.999, "Q3": 99999.999, "GridPosition": 19},
                "5": {"Q1": 89.462, "Q2": 99999.999, "Q3": 99999.999, "GridPosition": 20}
            },
            "raceStartTime": "2025-04-20T17:00:00+00:00",
            "raceLaps": 50
        },
        "Miami": {
            "outputFileName": "../tfrecord/miami",
            "dataTable": "miami",
            "lapsTable": "miamiLaps",
            "telemetryTable": "miamiTelemetry",
            "year": 2025,
            "roundNumber": 6,
            "city": "Miami",
            "session": 10033,
            "qualifyingData": {
                "1": {"Q1": 86.870, "Q2": 86.643, "Q3": 86.204, "GridPosition": 1},
                "4": {"Q1": 86.955, "Q2": 86.499, "Q3": 86.269, "GridPosition": 2},
                "12": {"Q1": 87.077, "Q2": 86.606, "Q3": 86.271, "GridPosition": 3},
                "81": {"Q1": 87.006, "Q2": 86.269, "Q3": 86.375, "GridPosition": 4},
                "63": {"Q1": 87.014, "Q2": 86.575, "Q3": 86.385, "GridPosition": 5},
                "55": {"Q1": 87.098, "Q2": 86.847, "Q3": 86.569, "GridPosition": 6},
                "23": {"Q1": 87.042, "Q2": 86.855, "Q3": 86.682, "GridPosition": 7},
                "16": {"Q1": 87.417, "Q2": 86.948, "Q3": 86.754, "GridPosition": 8},
                "31": {"Q1": 87.450, "Q2": 86.967, "Q3": 86.824, "GridPosition": 9},
                "22": {"Q1": 87.298, "Q2": 86.959, "Q3": 86.943, "GridPosition": 10},
                "6": {"Q1": 87.301, "Q2": 86.987, "Q3": 99999.999, "GridPosition": 11},
                "44": {"Q1": 87.279, "Q2": 87.006, "Q3": 99999.999, "GridPosition": 12},
                "5": {"Q1": 87.343, "Q2": 87.151, "Q3": 99999.999, "GridPosition": 13},
                "7": {"Q1": 87.422, "Q2": 87.186, "Q3": 99999.999, "GridPosition": 14},
                "30": {"Q1": 87.444, "Q2": 87.363, "Q3": 99999.999, "GridPosition": 15},
                "27": {"Q1": 87.473, "Q2": 99999.999, "Q3": 99999.999, "GridPosition": 16},
                "14": {"Q1": 87.604, "Q2": 99999.999, "Q3": 99999.999, "GridPosition": 17},
                "10": {"Q1": 87.710, "Q2": 99999.999, "Q3": 99999.999, "GridPosition": 18},
                "18": {"Q1": 87.830, "Q2": 99999.999, "Q3": 99999.999, "GridPosition": 19},
                "87": {"Q1": 87.999, "Q2": 99999.999, "Q3": 99999.999, "GridPosition": 20}
            },
            "raceStartTime": "2025-05-04T20:00:00+00:00",
            "raceLaps": 57
        },
        "Imola": {
            "outputFileName": "../tfrecord/imola",
            "dataTable": "imola",
            "lapsTable": "imolaLaps",
            "telemetryTable": "imolaTelemetry",
            "year": 2025,
            "roundNumber": 7,
            "city": "Imola",
            "session": 9987,
            "qualifyingData": {
                "81": {"Q1": 75.500, "Q2": 75.214, "Q3": 74.670, "GridPosition": 1},
                "1": {"Q1": 75.175, "Q2": 75.394, "Q3": 74.704, "GridPosition": 2},
                "63": {"Q1": 75.852, "Q2": 75.334, "Q3": 74.807, "GridPosition": 3},
                "4": {"Q1": 75.894, "Q2": 75.261, "Q3": 74.962, "GridPosition": 4},
                "14": {"Q1": 75.695, "Q2": 75.442, "Q3": 75.431, "GridPosition": 5},
                "55": {"Q1": 75.987, "Q2": 75.198, "Q3": 75.432, "GridPosition": 6},
                "23": {"Q1": 76.123, "Q2": 75.521, "Q3": 75.473, "GridPosition": 7},
                "18": {"Q1": 75.817, "Q2": 75.497, "Q3": 75.581, "GridPosition": 8},
                "6": {"Q1": 76.253, "Q2": 75.510, "Q3": 75.746, "GridPosition": 9},
                "10": {"Q1": 75.937, "Q2": 75.505, "Q3": 75.787, "GridPosition": 10},
                "16": {"Q1": 76.108, "Q2": 75.604, "Q3": 99999.999, "GridPosition": 11},
                "44": {"Q1": 76.163, "Q2": 75.765, "Q3": 99999.999, "GridPosition": 12},
                "12": {"Q1": 75.943, "Q2": 75.772, "Q3": 99999.999, "GridPosition": 13},
                "5": {"Q1": 76.340, "Q2": 76.260, "Q3": 99999.999, "GridPosition": 14},
                "43": {"Q1": 76.256, "Q2": 99999.999, "Q3": 99999.999, "GridPosition": 15},
                "30": {"Q1": 76.379, "Q2": 99999.999, "Q3": 99999.999, "GridPosition": 16},
                "27": {"Q1": 76.518, "Q2": 99999.999, "Q3": 99999.999, "GridPosition": 17},
                "31": {"Q1": 76.613, "Q2": 99999.999, "Q3": 99999.999, "GridPosition": 18},
                "87": {"Q1": 76.918, "Q2": 99999.999, "Q3": 99999.999, "GridPosition": 19},
                "22": {"Q1": 99999.999, "Q2": 99999.999, "Q3": 99999.999, "GridPosition": 20}
            },
            "raceStartTime": "2025-05-18T13:00:00+00:00",
            "raceLaps": 63
        },
        "Monaco": {
            "outputFileName": "../tfrecord/monaco",
            "dataTable": "monaco",
            "lapsTable": "monacoLaps",
            "telemetryTable": "monacoTelemetry",
            "year": 2025,
            "roundNumber": 8,
            "city": "Monaco",
            "session": 9979,
            "qualifyingData": {
                "4": {"Q1": 71.285, "Q2": 70.57, "Q3": 69.954, "GridPosition": 1},
                "16": {"Q1": 71.229, "Q2": 70.581, "Q3": 70.063, "GridPosition": 2},
                "81": {"Q1": 71.308, "Q2": 70.858, "Q3": 70.129, "GridPosition": 3},
                "44": {"Q1": 71.575, "Q2": 70.883, "Q3": 70.382, "GridPosition": 4},
                "1": {"Q1": 71.431, "Q2": 70.875, "Q3": 70.669, "GridPosition": 5},
                "6": {"Q1": 71.811, "Q2": 71.04, "Q3": 70.923, "GridPosition": 6},
                "14": {"Q1": 71.674, "Q2": 71.182, "Q3": 70.924, "GridPosition": 7},
                "31": {"Q1": 71.839, "Q2": 71.262, "Q3": 70.942, "GridPosition": 8},
                "30": {"Q1": 71.818, "Q2": 71.25, "Q3": 71.129, "GridPosition": 9},
                "23": {"Q1": 71.629, "Q2": 70.732, "Q3": 71.213, "GridPosition": 10},
                "55": {"Q1": 71.707, "Q2": 71.362, "Q3": 99999.999, "GridPosition": 11},
                "22": {"Q1": 71.8, "Q2": 71.415, "Q3": 99999.999, "GridPosition": 12},
                "27": {"Q1": 71.871, "Q2": 71.596, "Q3": 99999.999, "GridPosition": 13},
                "63": {"Q1": 71.507, "Q2": 99999.999, "Q3": 99999.999, "GridPosition": 14},
                "12": {"Q1": 71.88, "Q2": 99999.999, "Q3": 99999.999, "GridPosition": 15},
                "5": {"Q1": 71.902, "Q2": 99999.999, "Q3": 99999.999, "GridPosition": 16},
                "87": {"Q1": 71.979, "Q2": 99999.999, "Q3": 99999.999, "GridPosition": 17},
                "10": {"Q1": 71.994, "Q2": 99999.999, "Q3": 99999.999, "GridPosition": 18},
                "18": {"Q1": 72.563, "Q2": 99999.999, "Q3": 99999.999, "GridPosition": 19},
                "43": {"Q1": 72.597, "Q2": 99999.999, "Q3": 99999.999, "GridPosition": 20}
            },
            "raceStartTime": "2025-05-25T13:00:00+00:00",
            "raceLaps": 78
        },
    }

    # Return the proper value based on the city
    if city not in data:
        city = "Melbourne"
        
    qualiData = data[city]
    return (
        [
            qualiData["outputFileName"],
            qualiData["dataTable"],
            qualiData["lapsTable"],
            qualiData["telemetryTable"],
            qualiData["year"],
            qualiData["roundNumber"],
            qualiData["city"],
            qualiData["session"],
            qualiData["qualifyingData"],
            qualiData["raceStartTime"]
        ],
        qualiData["year"],
        qualiData["roundNumber"],
        qualiData["raceStartTime"],
        qualiData["raceLaps"],
        qualiData["outputFileName"],
    )