__all__ = ["getRaces"]

def getRaces():
    """
    Returns a list of races across multiple Formula 1 seasons.

    Each race entry includes the year, round number, and host city.
    The data spans the 2022, 2023, and 2024 seasons and is hardcoded.

    Returns:
        list of dict: A list where each dictionary represents a race with the following keys:
            - year (int): The year the race took place.
            - roundNumber (int): The round number within the season.
            - City (str): The name of the host city.
    """
    
    return [
        # 2022 Season
        {"year": 2022, "roundNumber": 1, "City": "Sakhir"},
        {"year": 2022, "roundNumber": 2, "City": "Jeddah"},
        {"year": 2022, "roundNumber": 3, "City": "Melbourne"},
        {"year": 2022, "roundNumber": 4, "City": "Imola"},
        {"year": 2022, "roundNumber": 5, "City": "Miami"},
        {"year": 2022, "roundNumber": 6, "City": "Barcelona"},
        {"year": 2022, "roundNumber": 7, "City": "Monaco"},
        {"year": 2022, "roundNumber": 8, "City": "Baku"},
        {"year": 2022, "roundNumber": 9, "City": "Montreal"},
        {"year": 2022, "roundNumber": 10, "City": "Silverstone"},
        {"year": 2022, "roundNumber": 11, "City": "Spielberg"},
        {"year": 2022, "roundNumber": 12, "City": "Le Castellet"},
        {"year": 2022, "roundNumber": 13, "City": "Budapest"},
        {"year": 2022, "roundNumber": 14, "City": "Spa-Francorchamps"},
        {"year": 2022, "roundNumber": 15, "City": "Zandvoort"},
        {"year": 2022, "roundNumber": 16, "City": "Monza"},
        {"year": 2022, "roundNumber": 17, "City": "Singapore"},
        {"year": 2022, "roundNumber": 18, "City": "Suzuka"},
        {"year": 2022, "roundNumber": 19, "City": "Austin"},
        {"year": 2022, "roundNumber": 20, "City": "Mexico City"},
        {"year": 2022, "roundNumber": 21, "City": "Sao Paulo"},
        {"year": 2022, "roundNumber": 22, "City": "Abu Dhabi"},

        # 2023 Season
        {"year": 2023, "roundNumber": 1, "City": "Sakhir"},
        {"year": 2023, "roundNumber": 2, "City": "Jeddah"},
        {"year": 2023, "roundNumber": 3, "City": "Melbourne"},
        {"year": 2023, "roundNumber": 4, "City": "Baku"},
        {"year": 2023, "roundNumber": 5, "City": "Miami"},
        {"year": 2023, "roundNumber": 6, "City": "Monaco"},
        {"year": 2023, "roundNumber": 7, "City": "Barcelona"},
        {"year": 2023, "roundNumber": 8, "City": "Montreal"},
        {"year": 2023, "roundNumber": 9, "City": "Spielberg"},
        {"year": 2023, "roundNumber": 10, "City": "Silverstone"},
        {"year": 2023, "roundNumber": 11, "City": "Budapest"},
        {"year": 2023, "roundNumber": 12, "City": "Spa-Francorchamps"},
        {"year": 2023, "roundNumber": 13, "City": "Zandvoort"},
        {"year": 2023, "roundNumber": 14, "City": "Monza"},
        {"year": 2023, "roundNumber": 15, "City": "Singapore"},
        {"year": 2023, "roundNumber": 16, "City": "Suzuka"},
        {"year": 2023, "roundNumber": 17, "City": "Lusail"},
        {"year": 2023, "roundNumber": 18, "City": "Austin"},
        {"year": 2023, "roundNumber": 19, "City": "Mexico City"},
        {"year": 2023, "roundNumber": 20, "City": "Sao Paulo"},
        {"year": 2023, "roundNumber": 21, "City": "Las Vegas"},
        {"year": 2023, "roundNumber": 22, "City": "Abu Dhabi"},

        # 2024 Season
        {"year": 2024, "roundNumber": 1, "City": "Sakhir"},
        {"year": 2024, "roundNumber": 2, "City": "Jeddah"},
        {"year": 2024, "roundNumber": 3, "City": "Melbourne"},
        {"year": 2024, "roundNumber": 4, "City": "Suzuka"},
        {"year": 2024, "roundNumber": 5, "City": "Shanghai"},
        {"year": 2024, "roundNumber": 6, "City": "Miami"},
        {"year": 2024, "roundNumber": 7, "City": "Imola"},
        {"year": 2024, "roundNumber": 8, "City": "Monaco"},
        {"year": 2024, "roundNumber": 9, "City": "Montreal"},
        {"year": 2024, "roundNumber": 10, "City": "Barcelona"},
        {"year": 2024, "roundNumber": 11, "City": "Spielberg"},
        {"year": 2024, "roundNumber": 12, "City": "Silverstone"},
        {"year": 2024, "roundNumber": 13, "City": "Budapest"},
        {"year": 2024, "roundNumber": 14, "City": "Spa-Francorchamps"},
        {"year": 2024, "roundNumber": 15, "City": "Zandvoort"},
        {"year": 2024, "roundNumber": 16, "City": "Monza"},
        {"year": 2024, "roundNumber": 17, "City": "Baku"},
        {"year": 2024, "roundNumber": 18, "City": "Singapore"},
        {"year": 2024, "roundNumber": 19, "City": "Austin"},
        {"year": 2024, "roundNumber": 20, "City": "Mexico City"},
        {"year": 2024, "roundNumber": 21, "City": "Sao Paulo"},
        {"year": 2024, "roundNumber": 22, "City": "Las Vegas"},
        {"year": 2024, "roundNumber": 23, "City": "Lusail"},
        {"year": 2024, "roundNumber": 24, "City": "Abu Dhabi"},
    ]