# TensorFlow core library
import tensorflow as tf

class EarlyStopping(tf.keras.callbacks.Callback):
    def __init__(self, monitor="accuracy", value=0.95, verbose=1):
        super(EarlyStopping, self).__init__()
        self.monitor = monitor
        self.value = value
        self.verbose = verbose

    def on_epoch_end(self, epoch, logs=None):
        logs = logs or {}
        acc = logs.get(self.monitor)
        if acc is not None and acc >= self.value:
            if self.verbose > 0:
                print(f"\nAccuracy reached ({acc:.4f} >= {self.value}). Stopping training.")
            self.model.stop_training = True