
from PyQt6.QtCore import QThread, pyqtSignal

from utils.api_client import configure_esp32

class ConfigureThread(QThread):
    """
    ConfigureThread is a class that represents a thread that configures the ESP32-CAM with the Wi-Fi and MQTT credentials.
    """

    error = pyqtSignal(str)
    finished = pyqtSignal(bool)

    def __init__(self, wifi_ssid: str, wifi_password: str, broker_ip: str, broker_port: int, broker_username: str, broker_password: str, tls_cert: str) -> None:
        super().__init__()
        self.wifi_ssid = wifi_ssid
        self.wifi_password = wifi_password
        self.broker_ip = broker_ip
        self.broker_port = broker_port
        self.broker_username = broker_username
        self.broker_password = broker_password
        self.tls_cert = tls_cert

    def run(self) -> None:
        try:
            success = configure_esp32(self.wifi_ssid, self.wifi_password, self.broker_ip, self.broker_port, self.broker_username, self.broker_password, self.tls_cert)
            self.finished.emit(success)
        except Exception as e:
            self.error.emit(str(e))
