import os
import sys
import json

if getattr(sys, 'frozen', False): 
    CONFIG_DIR = os.path.join(sys._MEIPASS, "config") 
else: 
    CONFIG_DIR = os.path.dirname(os.path.abspath(__file__)) + "/../config"


def get_config() -> dict:
    with open(os.path.join(CONFIG_DIR, "config.json"), "r") as f:
        config = json.load(f)
    return config


def save_config(wifi_ssid: str, broker_ip: str, broker_port: int, broker_username: str, mqtt_cert_path: str) -> None:

    if os.path.exists(CONFIG_DIR) is False:
        os.makedirs(CONFIG_DIR)

    config = {
        "wifi_ssid": wifi_ssid,
        "broker_ip": broker_ip,
        "broker_port": broker_port,
        "broker_username": broker_username,
        "mqtt_cert_path": mqtt_cert_path
    }
    with open(os.path.join(CONFIG_DIR, "config.json"), "w") as f:
        json.dump(config, f, indent=4)


def delete_config() -> None:
    config_file = os.path.join(CONFIG_DIR, "config.json")
    if os.path.exists(config_file):
        os.remove(config_file)


def is_config_exists() -> bool:
    config_file = os.path.join(CONFIG_DIR, "config.json")
    if os.path.exists(config_file):
        return True
    else:
        return False