from PyQt6.QtWidgets import QApplication
from View.MainView import MainView
from View.ConfigView import ConfigView
from Controller.Controller import Controller
import sys
import logging

logging.basicConfig(level=logging.INFO) # Set the minimum level of logs to show


def main() -> None:

    app = QApplication(sys.argv)
    main_view = MainView()
    config_view = ConfigView()
    controller = Controller(main_view=main_view, config_view=config_view)
    
    sys.exit(app.exec())




if __name__ == '__main__':
    main()