from enum import Enum

class ESP32Resolution(Enum):
    FRAMESIZE_QVGA = (320, 240)
    FRAMESIZE_CIF = (400, 296)
    FRAMESIZE_VGA = (640, 480)
    FRAMESIZE_SVGA = (800, 600)
    FRAMESIZE_XGA = (1024, 768)
    FRAMESIZE_SXGA = (1280, 1024)

    def __str__(self):
        return f"({self.value[0]}x{self.value[1]})"
    
    def from_string(resolution: str) -> tuple[int, int]:
        """Convert a string to a resolution tuple."""
        width, height = map(int, resolution.strip("()").split("x"))
        for res in ESP32Resolution:
            if res.value == (width, height):
                return res.value
        raise ValueError(f"Invalid resolution: {resolution}")
