import numpy as np
import os
import cv2
from datetime import datetime
from PyQt6.QtWidgets import QFileDialog

def save_image(image_path, frame: np.ndarray) -> None:
    """Save the image to the specified path."""
    # Check if the directory is writable
    if not os.access(os.path.dirname(image_path), os.W_OK):
        raise PermissionError(f"Directory {os.path.dirname(image_path)} is not writable.")
    cv2.imwrite(image_path, frame)

def get_file_path(file_extension: str, title: str, types: str, parent) -> str:
    file_name = datetime.now().strftime("%Y-%m-%d_%H-%M-%S") + "." + file_extension
    file_path, _ = QFileDialog.getSaveFileName(parent, title, file_name, types)
    return file_path
