from PyQt6.QtWidgets import QVBoxLayout, QHBoxLayout, QWidget, QGraphicsScene, QPushButton

from PyQt6.QtCore import Qt

from View.FrameView import FrameView


class CaptureViewer(QWidget):
    """
    Class to create a viewer with a taking pictures and starting/stopping recording buttons.
    """

    def __init__(self, scene: QGraphicsScene,  parent=None):
        super().__init__(parent)
        
        # << -- FrameView setup -- >>
        self._scene = scene
        self._frame_view = FrameView()
        self._frame_view.setScene(self._scene)

        # << -- Buttons setup -- >>
        self.take_picture_button = QPushButton("Take Picture")
        self.start_stop_recording_button = QPushButton("Start Recording")
        self.start_stop_recording_button.setStyleSheet("background-color: green;")
        self._buttons_layout = QHBoxLayout()
        self._buttons_layout.addWidget(self.take_picture_button)
        self._buttons_layout.addWidget(self.start_stop_recording_button)

        # << -- Layout setup -- >>
        self._layout = QVBoxLayout()
        self.setLayout(self._layout)
        self._layout.addWidget(self._frame_view)
        self._layout.addLayout(self._buttons_layout)


    def resizeEvent(self, event):
        """Override the resize event to fit the view in the scene rect."""
        super().resizeEvent(event)
        self._frame_view.fitInView(self._scene.sceneRect(), mode=Qt.AspectRatioMode.KeepAspectRatio)

    def get_scene(self):
        """Get the scene of the FrameView"""
        return self._frame_view.scene
    
    def set_scene(self, scene: QGraphicsScene):
        """Set the scene for the FrameView"""
        self._scene = scene
        self._frame_view.setScene(self._scene)


            