from PyQt6.QtWidgets import QWidget, QVBoxLayout, QPushButton, QCheckBox, QMessageBox
from PyQt6.QtCore import pyqtSignal

from View.MQTTGroup import MQTTGroup
        
class ConfigView(QWidget):
    
    # << -- Signals -- >>
    close_signal = pyqtSignal() # Signal to notify when the configuration window is closed
    mqtt_connected = pyqtSignal() # Signal to notify when the MQTT client is connected
    mqtt_not_connected = pyqtSignal(str) # Signal to notify when the MQTT client is not connected

    def __init__(self) -> None:
        super().__init__()
        self._init_ui()
    
    def _init_ui(self) -> None:
        self.close_signal.connect(self.close)

        # << -- Window Setup -- >>
        self.setWindowTitle("Configuration")
        self.setMinimumSize(400, 400)
        self.setMaximumSize(400, 400)
        
        # << -- Widget Setup -- >>
        self.mqtt_group = MQTTGroup("MQTT Configuration")
        self.remember_settings_checkbox = QCheckBox("Remember Settings")
        self.help_button = QPushButton("❓ Help")
        self.connect_button = QPushButton("⚙️ Configure")

        self.remember_settings_checkbox.setChecked(False)
        self.help_button.setStyleSheet("background-color: orange;")
        self.connect_button.setStyleSheet("background-color: #3498db;")

        # << -- Callback Setup -- >>
        self.help_button.clicked.connect(self._show_help_popup)

        # << -- Layout Setup -- >>
        self.main_layout = QVBoxLayout()
        self.main_layout.addWidget(self.mqtt_group)
        self.main_layout.addWidget(self.remember_settings_checkbox)
        self.main_layout.addWidget(self.help_button)
        self.main_layout.addWidget(self.connect_button)
        self.setLayout(self.main_layout)
    

    def _show_help_popup(self) -> None:
        text = "➤ This configuration window allows you to connect with the MQTT broker, so that interact with the ESP32-CAM and Notification Service.\n\n"
        text += "⚠️ In order to apply the configuration correctly, it is important that you first connect to the Wi-Fi network of the MQTT broker\n\n"
        text += "➤ After configuring, the program will automatically connect you with the MQTT broker with the specified fields."
        QMessageBox.information(self, "Help", text)