from model_chat import ChatRequest, ChatResponse
from bedrock_service import BedrockService
from vector_service import VectorService

bedrock_service = BedrockService()
vector_service = VectorService()

def chat(request: ChatRequest):
    try:
        # Obtener servicios relevantes
        relevant_services = vector_service.get_relevant_services(request.message)
        
        # Generar respuesta con Claude
        response = bedrock_service.generate_response(
            message=request.message,
            services=relevant_services
        )
        
        return ChatResponse(
            response=response,
            services=relevant_services
        )
    except Exception as e:
        raise Exception(status_code=500, detail=str(e)) 
    
    
if __name__ == "__main__":
    request = ChatRequest(message="Necesito un servicio de fotografía para un evento en la playa", user_id="123")
    response = chat(request)
    print(response)
