from datetime import time
import random
import sqlite3
import json
import uuid

DB_PATH = r'C:\Users\ensan\OneDrive\Documentos\EnginyeriaInformatica-UB\TFG\GITHUB\TFG\tfg_db.sqlite'
conn = sqlite3.connect(DB_PATH)
cur = conn.cursor()

def get_random_days():
    """Genera una lista aleatoria de días de la semana"""
    all_days = [1, 2, 3, 4, 5, 6, 7]
    # Selecciona entre 3 y 7 días aleatorios
    num_days = random.randint(3, 7)
    return random.sample(all_days, num_days)

def get_random_time():
    """Genera una hora aleatoria entre las 8:00 y las 20:00"""
    hour = random.randint(8, 14)
    minute = random.choice([0, 15, 30, 45])
    return time(hour, minute)

def get_random_price():
    """Genera un precio aleatorio entre 50€ y 200€"""
    return round(random.uniform(50.0, 200.0), 2)

def get_random_min_days():
    """Genera un número aleatorio de días mínimos entre 1 y 7"""
    return random.randint(1, 7)

def add_default_availability():
    """Añade disponibilidad por defecto a los servicios de tipo moniliari-decoracio que no tengan reglas"""
    # Obtener todos los servicios de tipo moniliari-decoracio
    cur.execute("SELECT * FROM service WHERE type = 'MOBILIARI_DECORACIO'")
    services = cur.fetchall()
    for service in services:
        service_id = service[9]  # El ID está en la primera columna
        
        # Verificar si el servicio ya tiene reglas de disponibilidad
        cur.execute("SELECT id FROM availabilityrule WHERE service_id = ?", (service_id,))
        existing_rules = cur.fetchall()
        
        # Generar hora de inicio y fin aleatorias
        hora_inicio = get_random_time()
        # Asegurar que hora_fin es posterior a hora_inicio
        hora_fin = time(
            hora_inicio.hour + random.randint(3, 9),
            hora_inicio.minute
        )
        
        # Crear regla de disponibilidad con valores aleatorios
        dias_semana = get_random_days()
        rule_id = str(uuid.uuid4())  # Generar un ID único
        cur.execute("""
            INSERT INTO availabilityrule 
            (id, service_id, dias_semana, hora_inicio, hora_fin, price, min_days_before)
            VALUES (?, ?, ?, ?, ?, ?, ?)
        """, (
            rule_id,
            service_id,
            json.dumps(dias_semana),  # Convertir lista a JSON string
            hora_inicio.strftime('%H:%M'),
            hora_fin.strftime('%H:%M'),
            get_random_price(),
            get_random_min_days()
        ))
        print(f"Regla de disponibilidad añadida al servicio {service[1]} (ID: {service_id})")
    
        # Guardar los cambios
        conn.commit()

if __name__ == "__main__":
    add_default_availability()
    conn.close()
