from pydantic import BaseModel, Field
from typing import List, Dict, Any, Optional, Union, Generic, TypeVar
from enum import Enum
from uuid import UUID, uuid4


class Address(BaseModel):
    direccion: str
    ciudad: str
    codigo_postal: str
    provincia: str


class ServicioBase(BaseModel):
    id: UUID
    type: str
    name: str
    price: float
    images: List[str]
    description: str
    availability: bool
    availability_rule: List[str]
    services_extra: Dict[str, Any]
    account_id: UUID
    address: Address


class ServicioBaseCreate(BaseModel):
    type: str
    name: str
    price: float
    images: List[str]
    description: str
    availability: bool = True
    availability_rule: List[str]
    services_extra: Dict[str, Any]
    account_id: UUID
    address: Address


class ServicioBaseUpdate(BaseModel):
    name: Optional[str] = None
    price: Optional[float] = None
    images: Optional[List[str]] = None
    description: Optional[str] = None
    availability: Optional[bool] = None
    availability_rule: Optional[List[str]] = None
    services_extra: Optional[Dict[str, Any]] = None
    address: Optional[Address] = None


class ServicioBaseOut(ServicioBase):
    class Config:
        from_attributes = True


T = TypeVar('T')


class ListOut(BaseModel, Generic[T]):
    items: List[T]
    total: int
    skip: int
    limit: int 