from pydantic import BaseModel, Field
from typing import List, Dict, Any, Optional
from uuid import UUID
from enum import Enum

from app.model.base import ServicioBase, ServicioBaseCreate, ServicioBaseUpdate, ServicioBaseOut, Address


class EspaiType(str, Enum):
    FINCA = "FINCA"
    HOTEL = "HOTEL"
    RESTAURANTE = "RESTAURANTE"
    SALA = "SALA"
    JARDIN = "JARDIN"
    PLAYA = "PLAYA"
    CASTILLO = "CASTILLO"


class EspaiDetailsCreate(BaseModel):
    espai_type: EspaiType
    capacitat_min: int
    capacitat_max: int
    caracteristicas: List[str]


class EspaiDetailsUpdate(BaseModel):
    espai_type: Optional[EspaiType] = None
    capacitat_min: Optional[int] = None
    capacitat_max: Optional[int] = None
    caracteristicas: Optional[List[str]] = None


class EspaiDetails(BaseModel):
    id: UUID
    espai_type: EspaiType
    capacitat_min: int
    capacitat_max: int
    caracteristicas: List[str]


class EspaiDetailsOut(EspaiDetails):
    class Config:
        from_attributes = True


class EspaiCreate(ServicioBaseCreate):
    espai: EspaiDetailsCreate


class EspaiUpdate(ServicioBaseUpdate):
    espai: Optional[EspaiDetailsUpdate] = None


class Espai(ServicioBase):
    espai: EspaiDetails


class EspaiOut(ServicioBaseOut):
    espai: EspaiDetailsOut
    
    class Config:
        from_attributes = True 