from pydantic import BaseModel, Field
from typing import List, Dict, Any, Optional
from uuid import UUID
from enum import Enum

from app.model.base import ServicioBase, ServicioBaseCreate, ServicioBaseUpdate, ServicioBaseOut, Address


class FotografiaType(str, Enum):
    FOTOGRAFIA = "FOTOGRAFIA"


class ServicioEspecialType(str, Enum):
    ESPEJO_MAGICO = "ESPEJO_MAGICO"
    VIDEOCABINA = "VIDEOCABINA"
    DRON = "DRON"


class DimensionesEscenario(BaseModel):
    ancho: float
    largo: float
    alto: float


class IntegranteEquipo(BaseModel):
    nombre: str
    rol: str


class RaiderCreate(BaseModel):
    num_integrantes: int
    equipo: List[IntegranteEquipo]
    equipo_propio: bool
    coste_equipo_propio: float
    disponible_sin_equipo: bool
    dimensiones_escenario: DimensionesEscenario
    condiciones: List[str]


class RaiderUpdate(BaseModel):
    num_integrantes: Optional[int] = None
    equipo: Optional[List[IntegranteEquipo]] = None
    equipo_propio: Optional[bool] = None
    coste_equipo_propio: Optional[float] = None
    disponible_sin_equipo: Optional[bool] = None
    dimensiones_escenario: Optional[DimensionesEscenario] = None
    condiciones: Optional[List[str]] = None


class Raider(BaseModel):
    id: UUID
    num_integrantes: int
    equipo: List[IntegranteEquipo]
    equipo_propio: bool
    coste_equipo_propio: float
    disponible_sin_equipo: bool
    dimensiones_escenario: DimensionesEscenario
    condiciones: List[str]


class RaiderOut(Raider):
    class Config:
        from_attributes = True


class FotografiaDetailsCreate(BaseModel):
    fotografia_type: FotografiaType
    servicio_especial_type: Optional[ServicioEspecialType] = None
    duracion: float
    caracteristicas: List[str]
    raider: RaiderCreate


class FotografiaDetailsUpdate(BaseModel):
    fotografia_type: Optional[FotografiaType] = None
    servicio_especial_type: Optional[ServicioEspecialType] = None
    duracion: Optional[float] = None
    caracteristicas: Optional[List[str]] = None
    raider: Optional[RaiderUpdate] = None


class FotografiaDetails(BaseModel):
    id: UUID
    fotografia_type: FotografiaType
    servicio_especial_type: Optional[ServicioEspecialType]
    duracion: float
    caracteristicas: List[str]
    raider_id: UUID
    raider: Raider


class FotografiaDetailsOut(FotografiaDetails):
    class Config:
        from_attributes = True


class FotografiaCreate(ServicioBaseCreate):
    fotografia: FotografiaDetailsCreate


class FotografiaUpdate(ServicioBaseUpdate):
    fotografia: Optional[FotografiaDetailsUpdate] = None


class Fotografia(ServicioBase):
    fotografia: FotografiaDetails


class FotografiaOut(ServicioBaseOut):
    fotografia: FotografiaDetailsOut
    
    class Config:
        from_attributes = True 