from pydantic import BaseModel, Field
from typing import List, Dict, Any, Optional, Union
from uuid import UUID
from enum import Enum

from app.model.base import ServicioBase, ServicioBaseCreate, ServicioBaseUpdate, ServicioBaseOut, Address


class ServiceType(str, Enum):
    MOBILIARIO = "MOBILIARIO"
    DECORACION = "DECORACION"


class TipologiaMobiliario(str, Enum):
    MESAS = "MESAS"
    SILLAS = "SILLAS"
    CARPAS = "CARPAS"
    TARIMAS = "TARIMAS"
    BARRAS = "BARRAS"
    ESTANTERIAS = "ESTANTERIAS"
    ILUMINACION = "ILUMINACION"


class TipologiaDecoracion(str, Enum):
    FLORES = "FLORES"
    GLOBOS = "GLOBOS"
    TELAS = "TELAS"
    ESTRUCTURAS = "ESTRUCTURAS"
    ELEMENTOS_TEMATICOS = "ELEMENTOS_TEMATICOS"
    PHOTOCALLS = "PHOTOCALLS"


Tipologia = Union[TipologiaMobiliario, TipologiaDecoracion]


class Dimensiones(BaseModel):
    width: float
    height: float
    depth: float


class DimensionesUpdate(BaseModel):
    width: Optional[float] = None
    height: Optional[float] = None
    depth: Optional[float] = None


class MobiliariDecoracionDetailsCreate(BaseModel):
    service_type: ServiceType
    tipologia: str
    is_rental: bool
    cantidad_min: int
    cantidad_max: int
    subtipologia: Optional[str] = None
    forma: Optional[str] = None
    modality: Optional[str] = None
    color: List[str]
    material: List[str]
    style: str
    size: str
    caracteristicas: List[str]
    complement: Optional[str] = None
    dimensiones: Dimensiones


class MobiliariDecoracionDetailsUpdate(BaseModel):
    service_type: Optional[ServiceType] = None
    tipologia: Optional[str] = None
    is_rental: Optional[bool] = None
    cantidad_min: Optional[int] = None
    cantidad_max: Optional[int] = None
    subtipologia: Optional[str] = None
    forma: Optional[str] = None
    modality: Optional[str] = None
    color: Optional[List[str]] = None
    material: Optional[List[str]] = None
    style: Optional[str] = None
    size: Optional[str] = None
    caracteristicas: Optional[List[str]] = None
    complement: Optional[str] = None
    dimensiones: Optional[DimensionesUpdate] = None


class MobiliariDecoracionDetails(BaseModel):
    id: UUID
    service_type: ServiceType
    tipologia: str
    is_rental: bool
    cantidad_min: int
    cantidad_max: int
    subtipologia: Optional[str] = None
    forma: Optional[str] = None
    modality: Optional[str] = None
    color: List[str]
    material: List[str]
    style: str
    size: str
    caracteristicas: List[str]
    complement: Optional[str] = None
    dimensiones: Dimensiones


class MobiliariDecoracionDetailsOut(MobiliariDecoracionDetails):
    class Config:
        from_attributes = True


class MobiliariDecoracioCreate(ServicioBaseCreate):
    mobiliari_decoracio: MobiliariDecoracionDetailsCreate


class MobiliariDecoracioUpdate(ServicioBaseUpdate):
    mobiliari_decoracio: Optional[MobiliariDecoracionDetailsUpdate] = None


class MobiliariDecoracio(ServicioBase):
    mobiliari_decoracio: MobiliariDecoracionDetails


class MobiliariDecoracioOut(ServicioBaseOut):
    mobiliari_decoracio: MobiliariDecoracionDetailsOut
    
    class Config:
        from_attributes = True 