import sqlite3
import os

# Cambia la ruta al archivo de tu base de datos
db_path = r'C:\Users\ensan\OneDrive\Documentos\EnginyeriaInformatica-UB\TFG\GITHUB\TFG\tfg_db.sqlite'

conn = sqlite3.connect(db_path)
cur = conn.cursor()

# ID a eliminar
id_to_delete = '3e9758bf5caa4ae5af43b45766366fbc'

# Verificar si existen los registros
cur.execute("SELECT * FROM service WHERE id = ?", (id_to_delete,))
service_record = cur.fetchone()

cur.execute("SELECT * FROM mobiliaridecoracio WHERE id = ?", (id_to_delete,))
mobiliar_record = cur.fetchone()

# Mostrar los registros encontrados
if service_record:
    print("\nRegistro encontrado en la tabla 'service':")
    print(service_record)
else:
    print("\nNo se encontró ningún registro en la tabla 'service' con ese ID")

if mobiliar_record:
    print("\nRegistro encontrado en la tabla 'mobiliaridecoracio':")
    print(mobiliar_record)
else:
    print("\nNo se encontró ningún registro en la tabla 'mobiliaridecoracio' con ese ID")

# Preguntar confirmación si se encontraron registros
if service_record or mobiliar_record:
    confirmacion = input("\n¿Estás seguro de que quieres eliminar estos registros? (s/n): ")
    
    if confirmacion.lower() == 's':
        # Eliminar los registros
        if service_record:
            cur.execute("DELETE FROM service WHERE id = ?", (id_to_delete,))
            print("Registro eliminado de la tabla 'service'")
            
        if mobiliar_record:
            cur.execute("DELETE FROM mobiliaridecoracio WHERE id = ?", (id_to_delete,))
            print("Registro eliminado de la tabla 'mobiliaridecoracio'")
            
        conn.commit()
        print("\nOperación completada. Registros eliminados correctamente.")
    else:
        print("\nOperación cancelada. No se han eliminado registros.")
else:
    print("\nNo hay registros para eliminar.")

conn.close()
    