from geopy.geocoders import Nominatim
from geopy.distance import geodesic

# Crear geolocalizador
geolocator = Nominatim(user_agent="distance_calculator")

# Direcciones
direccion1 = "Carrer Sastre, 56, Barcelona"
direccion2 = "Plaça de Catalunya, Barcelona, España"

# Obtener coordenadas
location1 = geolocator.geocode(direccion1)
location2 = geolocator.geocode(direccion2)

coord1 = (location1.latitude, location1.longitude)
coord2 = (location2.latitude, location2.longitude)

# Calcular distancia en km
distancia_km = geodesic(coord1, coord2).kilometers

print(f"La distancia entre las direcciones es {distancia_km:.2f} km")
