import json
import random
from typing import List, Dict, Any

# Nombres para servicios de catering
nombres_catering = [
    "Menú Mediterráneo Premium",
    "Banquete Gourmet Selección",
    "Buffet Internacional Deluxe",
    "Catering Ejecutivo Corporativo",
    "Menú Degustación Gourmet",
    "Catering Premium para Bodas",
    "Buffet de Cocina Fusión",
    "Catering Ecológico Sostenible",
    "Menú Celebración Exclusivo",
    "Catering Temático Experiencia",
    "Cocktail Degustación Especial",
    "Menú Tradicional de Autor",
    "Catering Finger Food Premium",
    "Buffet Gastronómico Regional",
    "Menú Ejecutivo Personalizado",
    "Catering Gourmet para Eventos",
    "Menú Celebración Familiar",
    "Estaciones Gastronómicas Premium",
    "Catering Brunch VIP",
    "Menú Eventos Corporativos",
    "Banquete Nupcial Selecto",
    "Catering Cócteles y Aperitivos",
    "Menú Formal de Gala",
    "Buffet Mediterráneo Selección",
    "Catering Eventos al Aire Libre",
    "Menú Degustación Especial",
    "Catering Gastrobar Experiencia",
    "Buffet Internacional Premium",
    "Menú Privado Exclusivo",
    "Catering Lujo para Eventos"
]

# Descripciones para servicios de catering
descripciones_catering = [
    "Servicio de catering mediterráneo con productos de proximidad",
    "Experiencia gastronómica completa para bodas y celebraciones",
    "Buffet internacional con especialidades de diferentes países",
    "Servicio profesional para eventos corporativos y reuniones de empresa",
    "Menú degustación con platos de autor y maridaje incluido",
    "Catering premium todo incluido para bodas y celebraciones especiales",
    "Fusión de sabores internacionales con toques innovadores",
    "Catering sostenible con productos ecológicos y de proximidad",
    "Menú exclusivo para celebraciones importantes con servicio personalizado",
    "Experiencia temática completa con gastronomía especializada",
    "Selección de cócteles y aperitivos gourmet para eventos",
    "Cocina tradicional reinventada por nuestros chefs",
    "Selección premium de aperitivos elegantes para eventos formales",
    "Gastronomía regional con los mejores productos de temporada",
    "Menú ejecutivo personalizable para eventos corporativos",
    "Servicio gourmet con la mejor selección de platos para eventos especiales",
    "Menú para celebraciones familiares con servicio profesional",
    "Diferentes estaciones gastronómicas con cocina en vivo",
    "Brunch de lujo para eventos matinales o informales",
    "Soluciones gastronómicas para empresas y eventos corporativos",
    "Todo lo necesario para hacer de tu boda una experiencia inolvidable",
    "Selección premium de cócteles y aperitivos para eventos sociales",
    "Menú especial para galas y eventos formales",
    "Selección de platos mediterráneos con un toque contemporáneo",
    "Catering especializado para eventos en espacios exteriores",
    "Experiencia degustación con platos sorpresa del chef",
    "Concepto gastrobar llevado a tu evento con bebidas premium incluidas",
    "Buffet con especialidades internacionales seleccionadas",
    "Servicio exclusivo y personalizado para eventos privados",
    "Catering de lujo para los eventos más exclusivos"
]

# Características para servicios de catering
caracteristicas_catering = [
    "Servicio de camareros incluido",
    "Menaje y mantelería incluidos",
    "Montaje y desmontaje",
    "Cocina en vivo",
    "Barra libre opcional",
    "Decoración personalizada",
    "Opciones para todas las dietas",
    "Productos de proximidad",
    "Chef profesional en el evento",
    "Transporte incluido",
    "Degustación previa gratuita",
    "Opciones para niños",
    "Carta de vinos seleccionados",
    "Elaboración artesanal",
    "Adaptación a espacios reducidos",
    "Personal uniformado",
    "Coordinador de evento incluido",
    "Servicio de café premium",
    "Tartas personalizadas",
    "Productos de temporada",
    "Opciones de catering sostenible",
    "Mobiliario incluido",
    "Servicio de coctelería",
    "Bodega premium disponible",
    "Adaptación a intolerancias",
    "Servicio de recepción",
    "Coordinación con proveedores",
    "Estaciones temáticas",
    "Show cooking",
    "Servicio de banquete imperial"
]

# Platos para menús
platos_menu = [
    "Ensalada de burrata con tomate y albahaca",
    "Paella de marisco",
    "Surtido de postres caseros",
    "Tartar de atún con aguacate",
    "Risotto de setas silvestres",
    "Cochinillo confitado con puré de manzana",
    "Crema de calabaza con tostones",
    "Bacalao confitado con compota de tomate",
    "Solomillo Wellington con salsa de oporto",
    "Gazpacho andaluz con guarnición",
    "Pulpo a la brasa con parmentier de patata",
    "Tarta de queso con frutos rojos",
    "Ceviche de corvina y mango",
    "Canelones de rabo de toro",
    "Brownie de chocolate con helado",
    "Tataki de atún con sésamo",
    "Arroz meloso de bogavante",
    "Crema catalana con carquiñolis",
    "Jamón ibérico con pan de cristal y tomate",
    "Lenguado a la meunière",
    "Tiramisú casero",
    "Carpaccio de buey con parmesano",
    "Fideuà con alioli",
    "Coulant de chocolate con helado de vainilla",
    "Salmorejo cordobés",
    "Lubina al horno con verduras de temporada",
    "Cheesecake con coulis de frambuesa",
    "Tabla de quesos nacionales e internacionales",
    "Arroz negro con sepia",
    "Tarta tatin de manzana con crema inglesa"
]

# Opciones especiales para menús
opciones_especiales = [
    "Opción sin gluten",
    "Opción vegetariana",
    "Opción vegana",
    "Menú infantil",
    "Opción sin lactosa",
    "Platos fríos para verano",
    "Menú bajo en calorías",
    "Opción sin frutos secos",
    "Alternativa sin pescado",
    "Menú tradicional",
    "Menú internacional",
    "Menú fusión",
    "Cocina molecular",
    "Platos crudiveganos",
    "Menú kosher",
    "Menú halal",
    "Opciones bajas en sodio",
    "Alternativas sin azúcar",
    "Platos proteicos",
    "Menú detox"
]

# Servicios extra para catering
servicios_extra_catering = [
    {"incluye_bebidas": True, "opciones_vegetarianas": True, "decoracion_mesas": True},
    {"incluye_bebidas": True, "barra_libre": True, "mobiliario": True},
    {"opciones_veganas": True, "personal_extra": True, "transporte": True},
    {"decoracion_tematica": True, "musica_ambiente": True, "fotografo": True},
    {"menu_infantil": True, "animacion": True, "incluye_bebidas": True},
    {"opciones_vegetarianas": True, "degustacion_previa": True, "servicio_vip": True},
    {"transporte": True, "montaje": True, "recogida": True},
    {"musica_ambiente": True, "iluminacion": True, "incluye_bebidas": True},
    {"barra_cocteleria": True, "servicio_sumiller": True, "menu_degustacion": True},
    {"decoracion_mesas": True, "centros_florales": True, "minuta_personalizada": True},
    {"incluye_bebidas": True, "servicio_cafe": True, "mesas_tematicas": True},
    {"menu_infantil": True, "mobiliario": True, "carpa_exterior": True},
    {"opciones_vegetarianas": True, "opciones_veganas": True, "opciones_sin_gluten": True},
    {"fotografo": True, "video": True, "photocall": True},
    {"barra_libre": True, "cocteleria_premium": True, "servicio_sumiller": True},
    {"menu_degustacion": True, "maridaje": True, "show_cooking": True},
    {"transporte": True, "decoracion_tematica": True, "iluminacion": True},
    {"incluye_bebidas": True, "servicio_vip": True, "coordinacion_evento": True},
    {"montaje": True, "recogida": True, "limpieza": True},
    {"centros_florales": True, "decoracion_mesas": True, "minuta_personalizada": True},
    {"barra_libre": True, "mobiliario": True, "carpa_exterior": True},
    {"opciones_vegetarianas": True, "menu_infantil": True, "transporte": True},
    {"servicio_cafe": True, "mesa_dulce": True, "corner_salado": True},
    {"incluye_bebidas": True, "opciones_sin_gluten": True, "menu_degustacion": True},
    {"decoracion_tematica": True, "iluminacion": True, "mobiliario": True},
    {"servicio_vip": True, "degustacion_previa": True, "menu_personalizado": True},
    {"fotografo": True, "photocall": True, "album_digital": True},
    {"barra_cocteleria": True, "animacion": True, "show_cooking": True},
    {"transporte": True, "montaje": True, "coordinacion_evento": True},
    {"incluye_bebidas": True, "opciones_vegetarianas": True, "decoracion_tematica": True}
]

# Ciudades y provincias (reutilizadas del script anterior)
ciudades_provincias = [
    {"ciudad": "Barcelona", "provincia": "Barcelona", "codigo_postal": "08001"},
    {"ciudad": "Madrid", "provincia": "Madrid", "codigo_postal": "28001"},
    {"ciudad": "Valencia", "provincia": "Valencia", "codigo_postal": "46001"},
    {"ciudad": "Sevilla", "provincia": "Sevilla", "codigo_postal": "41001"},
    {"ciudad": "Zaragoza", "provincia": "Zaragoza", "codigo_postal": "50001"},
    {"ciudad": "Málaga", "provincia": "Málaga", "codigo_postal": "29001"},
    {"ciudad": "Bilbao", "provincia": "Vizcaya", "codigo_postal": "48001"},
    {"ciudad": "Alicante", "provincia": "Alicante", "codigo_postal": "03001"},
    {"ciudad": "Córdoba", "provincia": "Córdoba", "codigo_postal": "14001"},
    {"ciudad": "Valladolid", "provincia": "Valladolid", "codigo_postal": "47001"},
    {"ciudad": "Vigo", "provincia": "Pontevedra", "codigo_postal": "36201"},
    {"ciudad": "Gijón", "provincia": "Asturias", "codigo_postal": "33201"},
    {"ciudad": "Palma", "provincia": "Islas Baleares", "codigo_postal": "07001"},
    {"ciudad": "Las Palmas", "provincia": "Las Palmas", "codigo_postal": "35001"},
    {"ciudad": "Murcia", "provincia": "Murcia", "codigo_postal": "30001"}
]

# Nombres de calles (reutilizadas del script anterior)
calles = [
    "Calle Mayor", "Avenida Diagonal", "Plaza Catalunya", "Paseo de Gracia",
    "Calle Serrano", "Gran Vía", "Calle Alcalá", "Paseo del Prado",
    "Calle Colón", "Avenida del Puerto", "Plaza del Ayuntamiento", "Calle Ruzafa",
    "Avenida de la Constitución", "Calle Sierpes", "Plaza Nueva", "Calle Tetuán",
    "Paseo Independencia", "Plaza del Pilar", "Calle Alfonso", "Calle Don Jaime",
    "Calle Larios", "Plaza de la Merced", "Paseo del Parque", "Calle Granada",
    "Gran Vía de Don Diego López de Haro", "Plaza Circular", "Calle Ercilla", "Alameda Recalde"
]

# Disponibilidades (reutilizadas del script anterior)
disponibilidades = [
    ["L-V", "9:00-18:00"],
    ["L-S", "10:00-20:00"],
    ["L-D", "9:00-21:00"],
    ["L-V", "8:00-17:00"],
    ["L-S", "9:00-19:00"],
    ["M-S", "10:00-19:00"],
    ["X-D", "9:00-20:00"],
    ["J-D", "11:00-22:00"],
    ["V-D", "10:00-22:00"],
    ["L-D", "8:00-23:00"]
]

# Tipos de entrega de catering
tipos_entrega = ["SERVICIO_DOMICILIO", "RECOGIDA_LOCAL"]

# Tipos de catering
tipos_catering = ["BANQUETE_IMPERIAL", "BUFET", "COCKTAIL", "FAMILIAR"]

# Alérgenos
alergenos = [
    "GLUTEN", "LACTEOS", "FRUTOS_DE_CASCARA", "HUEVOS", "PESCADO",
    "CRUSTACEOS", "MOLUSCOS", "SOJA", "APIO", "MOSTAZA",
    "SESAMO", "ALTRAMUCES", "SULFITOS"
]

# Tipos de menú
tipos_menu = ["MEDITERRANEO", "CONTINENTAL", "ASIATICO", "VEGETARIANO", "VEGANO"]

# Generar UUIDs consistentes basados en índice (reutilizada del script anterior)
def generar_uuid(indice: int, offset: int = 0) -> str:
    # Crear UUID predecible basado en índice
    base_uuid = f"b{indice+offset:04d}0000-0000-4000-b000-00000000{indice+offset:04d}"
    return base_uuid

# Función para generar ejemplos de catering
def generar_caterings(cantidad: int) -> List[Dict[str, Any]]:
    caterings = []
    
    for i in range(cantidad):
        # Generar UUIDs para cada entidad relacionada
        servicio_id = generar_uuid(i, 1000)
        account_id = generar_uuid(i, 2000)
        catering_id = generar_uuid(i, 3000)
        
        # Seleccionar ciudad y provincia
        ciudad_provincia = random.choice(ciudades_provincias)
        
        # Generar servicio completo
        servicio = {
            "id": servicio_id,
            "type": "CATERING",
            "name": random.choice(nombres_catering),
            "price": round(random.uniform(50, 200), 2),
            "images": [
                f"https://ejemplo.com/catering{i}_1.jpg",
                f"https://ejemplo.com/catering{i}_2.jpg",
                f"https://ejemplo.com/catering{i}_3.jpg"
            ],
            "description": random.choice(descripciones_catering),
            "availability": random.choice([True, True, True, False]),  # Mayor probabilidad de disponible
            "availability_rule": random.choice(disponibilidades),
            "services_extra": servicios_extra_catering[i % len(servicios_extra_catering)],
            "account_id": account_id,
            "address": {
                "direccion": f"{random.choice(calles)} {random.randint(1, 150)}",
                "ciudad": ciudad_provincia["ciudad"],
                "codigo_postal": ciudad_provincia["codigo_postal"],
                "provincia": ciudad_provincia["provincia"]
            },
            "catering": {
                "id": catering_id,
                "tipo_entrega": random.choice(tipos_entrega),
                "tipo_catering": random.choice(tipos_catering),
                "min_comensales": random.randint(10, 50),
                "max_comensales": random.randint(50, 300),
                "duracion": round(random.uniform(2, 8), 1),
                "alergenos": random.sample(alergenos, k=random.randint(2, 5)),
                "caracteristicas": random.sample(caracteristicas_catering, k=random.randint(3, 5)),
                "menu": {
                    "type_menu": random.choice(tipos_menu),
                    "nombre": f"{random.choice(['Menú', 'Selección', 'Degustación'])} {random.choice(['Premium', 'Deluxe', 'Especial', 'Exclusivo'])}",
                    "descripcion": f"Menú {random.choice(['mediterráneo', 'internacional', 'gourmet', 'de temporada'])} con productos de {random.choice(['alta calidad', 'proximidad', 'temporada', 'denominación de origen'])}",
                    "platos": random.sample(platos_menu, k=random.randint(3, 5)),
                    "opciones_especiales": random.sample(opciones_especiales, k=random.randint(2, 4))
                }
            }
        }
        
        caterings.append(servicio)
    
    return caterings

# Generar los ejemplos
ejemplos_catering = generar_caterings(30)

# Guardar en un archivo JSON con formato legible
with open('ejemplos/catering.json', 'w', encoding='utf-8') as f:
    json.dump(ejemplos_catering, f, ensure_ascii=False, indent=2)

print(f"Se generaron {len(ejemplos_catering)} ejemplos de servicios de catering")

# Para mostrar un ejemplo
print("\nEjemplo de servicio de catering:")
print(json.dumps(ejemplos_catering[0], ensure_ascii=False, indent=2)) 