import json
import os

# Cargar los datos de todos_servicios.json
def cargar_todos_servicios():
    try:
        with open('ejemplos/todos_servicios.json', 'r', encoding='utf-8') as file:
            return json.load(file)
    except Exception as e:
        print(f"Error al cargar todos_servicios.json: {str(e)}")
        return []

# Convertir el formato de todos_servicios.json al formato de self.services
def convertir_a_formato_vector_service(todos_servicios):
    services = {
        "Espai": {},
        "Catering": {},
        "Mobiliari": {},
        "Decoració": {},
        "Musica": {},
        "Fotografia": {}
    }
    
    # Mapeo de tipos en mayúsculas a nombres de categorías
    mapeo_tipos = {
        "ESPAI": "Espai",
        "CATERING": "Catering",
        "MOBILIARI": "Mobiliari",
        "MOBILIARI_DECORACIO": None,  # Se determinará según service_type
        "DECORACION": "Decoració",
        "MUSICA": "Musica",
        "FOTOGRAFIA": "Fotografia"
    }
    
    for servicio in todos_servicios:
        tipo = servicio.get("type")
        nombre = servicio.get("name")
        
        # Determinar la categoría correcta
        categoria = None
        if tipo == "MOBILIARI_DECORACIO":
            # Verificar en mobiliari, decoracio o ambos objetos
            if "mobiliari" in servicio and servicio["mobiliari"].get("service_type") == "MOBILIARI":
                categoria = "Mobiliari"
            elif "decoracion" in servicio and servicio["decoracion"].get("service_type") == "DECORACION":
                categoria = "Decoració"
            # Si no tiene service_type, intentar inferir por el tipo de objeto presente
            elif "mobiliari" in servicio:
                categoria = "Mobiliari"
            elif "decoracion" in servicio:
                categoria = "Decoració"
            # Último recurso - verificar si hay un service_type en el objeto principal
            elif servicio.get("service_type") == "MOBILIARI":
                categoria = "Mobiliari"
            elif servicio.get("service_type") == "DECORACION":
                categoria = "Decoració"
        elif tipo in mapeo_tipos:
            categoria = mapeo_tipos[tipo]
        
        # Si se determinó una categoría válida, procesar el servicio
        if categoria:
            # Excluir campos específicos que no queremos en los detalles
            detalles = {k: v for k, v in servicio.items() if k not in ["id", "type", "name", "account_id"]}
            
            # Incluir atributos específicos de cada tipo (espai, catering, etc.)
            for tipo_especifico in ["espai", "catering", "mobiliari", "decoracion", "musica", "fotografia"]:
                if tipo_especifico in servicio:
                    # Añadir los atributos específicos del tipo al nivel principal de detalles
                    for k, v in servicio[tipo_especifico].items():
                        if k not in ["id", "raider_id", "raider"]:  # Evitar duplicación de IDs y raiders
                            detalles[k] = v
            
            services[categoria][nombre] = detalles
    
    return services

# Función principal
def main():
    todos_servicios = cargar_todos_servicios()
    if todos_servicios:
        services = convertir_a_formato_vector_service(todos_servicios)
        
        # Guardar el resultado en un archivo JSON con formato horizontal
        output_path = 'ejemplos/services_formato_vector.json'
        
        # Guardar con formato JSON en una sola línea por servicio
        with open(output_path, 'w', encoding='utf-8') as f:
            # Escribir la apertura del objeto JSON
            f.write('{\n')
            
            # Procesar cada categoría
            categorias = list(services.keys())
            for i, categoria in enumerate(categorias):
                f.write(f'  "{categoria}": {{\n')
                
                # Procesar cada servicio en la categoría
                servicios = list(services[categoria].items())
                for j, (nombre, detalles) in enumerate(servicios):
                    # Escribir el nombre del servicio y abrir sus atributos
                    f.write(f'    "{nombre}": {{')
                    
                    # Escribir todos los atributos en una línea
                    atributos = []
                    for key, value in detalles.items():
                        atributo = f'"{key}": {json.dumps(value, ensure_ascii=False)}'
                        atributos.append(atributo)
                    
                    f.write(', '.join(atributos))
                    
                    # Cerrar el objeto del servicio
                    if j == len(servicios) - 1:
                        f.write('}\n')  # Último servicio sin coma
                    else:
                        f.write('},\n')  # Coma después de cada servicio excepto el último
                
                # Cerrar la categoría
                if i == len(categorias) - 1:
                    f.write('  }\n')  # Última categoría sin coma
                else:
                    f.write('  },\n')  # Coma después de cada categoría excepto la última
            
            # Cerrar el objeto JSON principal
            f.write('}\n')
        
        print(f"Conversión completada. Resultado guardado en: {output_path}")
    else:
        print("No se pudo cargar los datos de todos_servicios.json")

if __name__ == "__main__":
    main() 