import json
import random
from typing import List, Dict, Any

# Nombres para servicios de decoración
nombres_decoracion = [
    "Arcos Florales y Centros de Mesa",
    "Decoración Temática para Eventos",
    "Elementos Decorativos Premium",
    "Decoración Floral Completa",
    "Ambientación Integral para Eventos",
    "Propuestas Decorativas Exclusivas",
    "Diseño Floral para Celebraciones",
    "Decoración Colgante y Aérea",
    "Ambientación con Luces y Velas",
    "Decoración Vintage para Eventos",
    "Elementos Florales de Gran Formato",
    "Photocall y Zonas de Experiencia",
    "Stands y Escenografías Temáticas",
    "Centros de Mesa Artísticos",
    "Decoración Minimalista Elegante"
]

# Descripciones para servicios de decoración
descripciones_decoracion = [
    "Elementos decorativos florales para eventos y celebraciones",
    "Decoración temática integral para crear ambientes únicos",
    "Elementos decorativos de alta calidad para eventos exclusivos",
    "Servicio completo de decoración floral para bodas y eventos",
    "Ambientación integral con diversos elementos decorativos coordinados",
    "Propuestas decorativas exclusivas adaptadas a cada cliente",
    "Diseño floral especializado para todo tipo de celebraciones",
    "Elementos decorativos colgantes y aéreos para impacto visual",
    "Creación de ambientes cálidos mediante luces y velas decorativas",
    "Decoración con piezas y elementos vintage para eventos con encanto",
    "Elementos florales de gran formato para eventos de alto impacto",
    "Diseño de photocall y zonas de experiencia para invitados",
    "Creación de stands y escenografías para eventos temáticos",
    "Centros de mesa artísticos diseñados específicamente para cada evento",
    "Decoración minimalista y elegante con líneas limpias y materiales seleccionados"
]

# Características para servicios de decoración
caracteristicas_decoracion = [
    "Flores de temporada",
    "Estructura desmontable",
    "Personalizable",
    "Iluminación LED integrada",
    "Materiales reciclables",
    "Adaptable a espacios",
    "Opciones de colores",
    "Alta durabilidad",
    "Diseño exclusivo",
    "Fácil instalación",
    "Elementos naturales",
    "Complementos decorativos",
    "Bajo mantenimiento",
    "Adaptable a temáticas",
    "Piezas artesanales",
    "Sistemas de montaje rápido",
    "Resistente a exteriores",
    "Coordinación cromática",
    "Elementos intercambiables",
    "Estilismo profesional",
    "Texturas variadas",
    "Iluminación controlable",
    "Estructuras auto-portantes",
    "Elementos suspendidos",
    "Acabados de alta calidad"
]

# Colores para decoración
colores_decoracion = [
    "blanco", "rosa", "verde", "azul", "dorado", "plateado", "rojo",
    "champagne", "violeta", "amarillo", "coral", "turquesa", "lavanda",
    "marfil", "burdeos", "naranja", "rosa palo", "verde oliva", "malva",
    "azul marino", "gris perla", "verde esmeralda", "frambuesa", "marrón"
]

# Materiales para decoración
materiales_decoracion = [
    "flores naturales", "estructura metálica", "papel", "tela", "cristal",
    "madera", "cerámica", "metacrilato", "seda", "terciopelo", "mimbre",
    "ratán", "porcelana", "bambú", "metal", "poliestireno", "pvc decorativo",
    "foam", "resina", "lino", "algodón", "poliéster", "látex", "arcilla"
]

# Estilos para decoración
estilos_decoracion = [
    "Romántico", "Minimalista", "Rústico", "Vintage", "Clásico", "Bohemio",
    "Industrial", "Moderno", "Nórdico", "Mediterráneo", "Art Deco",
    "Étnico", "Tropical", "Natural", "Elegante", "Ecológico", "Marítimo",
    "Campestre", "Colonial", "Contemporáneo"
]

# Tamaños para decoración
tamaños_decoracion = [
    "Grande", "Mediano", "Pequeño", "Extra grande", "Miniatura",
    "Ajustable", "Personalizable", "Estándar", "Variable",
    "De pie", "De mesa", "Colgante", "Desmontable", "Modular"
]

# Tipologías para decoración
tipologias_decoracion = [
    "FLORES", "GLOBOS", "TELAS", "ESTRUCTURAS", 
    "ELEMENTOS_TEMATICOS", "PHOTOCALLS"
]

# Formas para decoración
formas_decoracion = [
    "Arco", "Circular", "Rectangular", "Esférica", "Irregular",
    "Geométrica", "Orgánica", "Lineal", "Piramidal", "Cónica",
    "Cascada", "En espiral", "Cúbica", "Cilíndrica", "Asimétrica"
]

# Modalidades para decoración
modalidades_decoracion = [
    "Ceremonia", "Banquete", "Recepción", "Cóctel", "Exposición",
    "Aniversario", "Cumpleaños", "Conferencia", "Evento corporativo",
    "Escaparate", "Stand", "Escenario", "Photocall", "Mesa principal"
]

# Complementos para decoración
complementos_decoracion = [
    "Luces LED integradas", "Base estabilizadora", "Kit de sujeción",
    "Elementos colgantes adicionales", "Set de iluminación",
    "Complementos florales extra", "Kit de repuesto", "Sistema de anclaje",
    "Elementos complementarios a juego", "Sistema de transporte",
    "Cableado oculto", "Controlador remoto", "Difusores de aroma",
    "Elementos interactivos", "Componentes modulares adicionales"
]

# Servicios extra para decoración
servicios_extra_decoracion = [
    {"instalacion_incluida": True, "recogida_incluida": True, "personalizacion": True},
    {"transporte_incluido": True, "montaje_profesional": True, "desmontaje": True},
    {"diseño_personalizado": True, "asesoramiento": True, "mantenimiento": True},
    {"entrega_anticipada": True, "recogida_posterior": True, "montaje_incluido": True},
    {"personalización_colores": True, "coordinación_evento": True, "asistencia_técnica": True},
    {"sustitución_flores": True, "iluminación_especial": True, "desmontaje_incluido": True},
    {"proyecto_3d": True, "cambios_ultima_hora": True, "adaptación_espacios": True},
    {"materiales_premium": True, "flores_extra": True, "transporte_especializado": True},
    {"coordinación_cromática": True, "prueba_previa": True, "montaje_incluido": True},
    {"personal_especializado": True, "reposición": True, "desmontaje_incluido": True},
    {"cambios_estacionales": True, "efectos_especiales": True, "mantenimiento_evento": True},
    {"personalización_temática": True, "adaptación_clima": True, "entrega_precisa": True},
    {"asesoramiento_decorativo": True, "materiales_exclusivos": True, "montaje_incluido": True},
    {"diseño_personalizado": True, "prueba_previa": True, "desmontaje_incluido": True},
    {"asistencia_permanente": True, "servicio_emergencia": True, "mantenimiento_flores": True}
]

# Reutilizar funciones auxiliares y datos de ejemplos anteriores
ciudades_provincias = [
    {"ciudad": "Barcelona", "provincia": "Barcelona", "codigo_postal": "08001"},
    {"ciudad": "Madrid", "provincia": "Madrid", "codigo_postal": "28001"},
    {"ciudad": "Valencia", "provincia": "Valencia", "codigo_postal": "46001"},
    {"ciudad": "Sevilla", "provincia": "Sevilla", "codigo_postal": "41001"},
    {"ciudad": "Zaragoza", "provincia": "Zaragoza", "codigo_postal": "50001"},
    {"ciudad": "Málaga", "provincia": "Málaga", "codigo_postal": "29001"},
    {"ciudad": "Bilbao", "provincia": "Vizcaya", "codigo_postal": "48001"},
    {"ciudad": "Alicante", "provincia": "Alicante", "codigo_postal": "03001"},
    {"ciudad": "Córdoba", "provincia": "Córdoba", "codigo_postal": "14001"},
    {"ciudad": "Valladolid", "provincia": "Valladolid", "codigo_postal": "47001"},
    {"ciudad": "Vigo", "provincia": "Pontevedra", "codigo_postal": "36201"},
    {"ciudad": "Gijón", "provincia": "Asturias", "codigo_postal": "33201"},
    {"ciudad": "Palma", "provincia": "Islas Baleares", "codigo_postal": "07001"},
    {"ciudad": "Las Palmas", "provincia": "Las Palmas", "codigo_postal": "35001"},
    {"ciudad": "Murcia", "provincia": "Murcia", "codigo_postal": "30001"}
]

calles = [
    "Paseo de Gracia", "Calle Serrano", "Gran Vía", "Calle Alcalá", 
    "Paseo del Prado", "Calle Colón", "Avenida del Puerto", 
    "Plaza del Ayuntamiento", "Calle Ruzafa", "Avenida de la Constitución", 
    "Calle Sierpes", "Plaza Nueva", "Calle Tetuán", "Paseo Independencia", 
    "Plaza del Pilar", "Calle Alfonso", "Calle Don Jaime", "Calle Larios", 
    "Plaza de la Merced", "Paseo del Parque", "Calle Granada", 
    "Gran Vía de Don Diego López de Haro", "Plaza Circular", "Calle Ercilla", 
    "Alameda Recalde", "Calle Mayor", "Avenida Diagonal", "Plaza Catalunya"
]

disponibilidades = [
    ["L-V", "9:00-18:00"],
    ["L-S", "10:00-20:00"],
    ["L-D", "9:00-21:00"],
    ["L-V", "8:00-17:00"],
    ["L-S", "9:00-19:00"],
    ["M-S", "10:00-19:00"],
    ["X-D", "9:00-20:00"],
    ["J-D", "11:00-22:00"],
    ["V-D", "10:00-22:00"],
    ["L-D", "9:00-18:00"]
]

# Generar UUIDs consistentes basados en índice
def generar_uuid(indice: int, offset: int = 0) -> str:
    # Crear UUID predecible basado en índice
    base_uuid = f"f{indice+offset:04d}0000-0000-4000-f000-00000000{indice+offset:04d}"
    return base_uuid

# Función para generar ejemplos de decoración
def generar_decoracion(cantidad: int) -> List[Dict[str, Any]]:
    decoraciones = []
    
    for i in range(cantidad):
        # Generar UUIDs para cada entidad relacionada
        servicio_id = generar_uuid(i, 1000)
        account_id = generar_uuid(i, 2000)
        decoracion_id = generar_uuid(i, 3000)
        
        # Seleccionar ciudad y provincia
        ciudad_provincia = random.choice(ciudades_provincias)
        
        # Determinar capacidad y tipología
        tipologia = random.choice(tipologias_decoracion)
        cantidad_min = random.randint(1, 10)
        cantidad_max = cantidad_min + random.randint(10, 30)
        
        # Seleccionar dimensiones según el tipo de decoración
        if tipologia == "ESTRUCTURAS" or tipologia == "PHOTOCALLS":
            width = random.randint(150, 350) * 1.0
            height = random.randint(180, 300) * 1.0
            depth = random.randint(30, 100) * 1.0
        elif tipologia == "FLORES":
            width = random.randint(30, 250) * 1.0
            height = random.randint(40, 250) * 1.0
            depth = random.randint(30, 80) * 1.0
        else:
            width = random.randint(50, 200) * 1.0
            height = random.randint(50, 200) * 1.0
            depth = random.randint(20, 70) * 1.0
        
        # Generar servicio completo
        servicio = {
            "id": servicio_id,
            "type": "MOBILIARI_DECORACIO",
            "name": random.choice(nombres_decoracion),
            "price": round(random.uniform(300, 2500), 2),
            "images": [
                f"https://ejemplo.com/decoracion{i}_1.jpg",
                f"https://ejemplo.com/decoracion{i}_2.jpg"
            ],
            "description": random.choice(descripciones_decoracion),
            "availability": random.choice([True, True, True, False]),  # Mayor probabilidad de disponible
            "availability_rule": random.choice(disponibilidades),
            "services_extra": random.choice(servicios_extra_decoracion),
            "account_id": account_id,
            "address": {
                "direccion": f"{random.choice(calles)} {random.randint(1, 150)}",
                "ciudad": ciudad_provincia["ciudad"],
                "codigo_postal": ciudad_provincia["codigo_postal"],
                "provincia": ciudad_provincia["provincia"]
            },
            "mobiliari_decoracio": {
                "id": decoracion_id,
                "service_type": "DECORACION",
                "tipologia": tipologia,
                "is_rental": random.choice([True, True, False]),  # Mayor probabilidad de alquiler
                "cantidad_min": cantidad_min,
                "cantidad_max": cantidad_max,
                "subtipologia": f"{random.choice(['Arco', 'Centro', 'Instalación', 'Estructura', 'Elemento'])} {random.choice(['floral', 'decorativo', 'personalizado', 'temático', 'exclusivo'])}",
                "forma": random.choice(formas_decoracion),
                "modality": random.choice(modalidades_decoracion),
                "color": random.sample(colores_decoracion, k=random.randint(1, 4)),
                "material": random.sample(materiales_decoracion, k=random.randint(1, 3)),
                "style": random.choice(estilos_decoracion),
                "size": random.choice(tamaños_decoracion),
                "caracteristicas": random.sample(caracteristicas_decoracion, k=random.randint(3, 5)),
                "complement": random.choice(complementos_decoracion),
                "dimensiones": {
                    "width": width,
                    "height": height,
                    "depth": depth
                }
            }
        }
        
        decoraciones.append(servicio)
    
    return decoraciones

# Generar los ejemplos
ejemplos_decoracion = generar_decoracion(15)  # Generar 15 ejemplos de decoración

# Guardar en un archivo JSON con formato legible
with open('ejemplos/decoracion.json', 'w', encoding='utf-8') as f:
    json.dump(ejemplos_decoracion, f, ensure_ascii=False, indent=2)

# Para mostrar un ejemplo
print(f"Se generaron {len(ejemplos_decoracion)} ejemplos de servicios de decoración")
print("\nEjemplo de servicio de decoración:")
print(json.dumps(ejemplos_decoracion[0], ensure_ascii=False, indent=2)) 