import json
import random
from typing import List, Dict, Any

# Nombres para espacios
nombres_espai = [
    "Villa Mediterránea",
    "Masía Can Ribas",
    "Finca El Mirador",
    "Palacio de los Duques",
    "Hotel Boutique Elegance",
    "Jardines La Rosaleda",
    "Castillo de San Fernando",
    "Espacio Industrial Loft",
    "Hacienda Los Olivos",
    "Beach Club Costa Brava",
    "Terraza Skyline",
    "Casa Rural El Encinar",
    "Bodega Viñedo Antiguo",
    "Complejo Eventos Montaña",
    "Parador Nacional",
    "Cortijo Andaluz",
    "Claustro Histórico",
    "Finca Vista Mar",
    "Palacete Modernista",
    "Nave Industrial Restaurada",
    "Salones Reales",
    "Casa Palacio Siglo XVIII",
    "Jardín Botánico",
    "Club Náutico Marina",
    "Villa con Vistas",
    "Antigua Fábrica",
    "Resort & Spa Exclusivo",
    "Museo de Arte Contemporáneo",
    "Casa Señorial con Jardines",
    "Espacio Multifuncional Moderno"
]

# Descripciones para espacios
descripciones_espai = [
    "Espectacular villa con vistas al mar para eventos exclusivos",
    "Masía catalana restaurada con amplios jardines y piscina",
    "Finca con impresionantes vistas panorámicas para eventos al aire libre",
    "Palacio señorial con salones elegantes para celebraciones distinguidas",
    "Hotel boutique con encanto para bodas íntimas y eventos exclusivos",
    "Jardines exuberantes con espacios versátiles para eventos al aire libre",
    "Castillo histórico con amplios espacios para grandes celebraciones",
    "Espacio industrial reconvertido ideal para eventos modernos y originales",
    "Hacienda rodeada de olivos centenarios con múltiples espacios para eventos",
    "Club de playa con terraza sobre el mar para celebraciones estivales",
    "Terraza urbana con vistas panorámicas a la ciudad para eventos exclusivos",
    "Casa rural con encanto en plena naturaleza para celebraciones íntimas",
    "Bodega tradicional entre viñedos para eventos con carácter",
    "Complejo en la montaña con múltiples espacios interiores y exteriores",
    "Edificio histórico con elegantes salones y jardines centenarios",
    "Auténtico cortijo con patios andaluces y amplios espacios",
    "Antiguo claustro restaurado para eventos con historia",
    "Finca con impresionantes vistas al mar para eventos únicos",
    "Palacete de estilo modernista con detalles arquitectónicos exclusivos",
    "Antigua nave industrial transformada en espacio versátil para eventos",
    "Salones de estilo clásico para celebraciones elegantes",
    "Casa palacio del siglo XVIII con patio central y jardines",
    "Jardín botánico con espacios para eventos rodeados de naturaleza",
    "Club náutico con vistas al puerto deportivo para eventos marítimos",
    "Villa exclusiva con vistas panorámicas para celebraciones privadas",
    "Fábrica reconvertida en espacio multifuncional con carácter industrial",
    "Resort con spa e instalaciones de lujo para eventos premium",
    "Museo con salas exclusivas para eventos culturales y corporativos",
    "Casa señorial rodeada de jardines históricos para eventos elegantes",
    "Espacio contemporáneo adaptable a todo tipo de necesidades"
]

# Características para espacios
caracteristicas_espai = [
    "Jardines con piscina",
    "Vistas panorámicas al mar",
    "Cocina equipada",
    "Aparcamiento privado",
    "Acceso para personas con movilidad reducida",
    "Terraza con vistas",
    "Salón climatizado",
    "Iluminación ambiental",
    "Espacio para ceremonias",
    "Zona de baile",
    "Mobiliario incluido",
    "Escenario para música en directo",
    "Zona de cocktail independiente",
    "Jardines iluminados",
    "Pista de baile",
    "Sistema de sonido profesional",
    "Zona chill out",
    "Diversos espacios para fotos",
    "Capilla propia",
    "Habitaciones para invitados",
    "Fuente ornamental",
    "Espacio para carpa exterior",
    "Arquitectura histórica",
    "Espacios versátiles",
    "Zona para niños",
    "Posibilidad de fuegos artificiales",
    "Helipuerto",
    "Embarcadero propio",
    "Spa y zona wellness",
    "Exclusividad total del recinto"
]

# Servicios extra para espacios
servicios_extra_espai = [
    {"parking": True, "wifi": True, "accesibilidad": True},
    {"ceremonia_civil": True, "alojamiento": True, "personal_seguridad": True},
    {"coordinador_eventos": True, "guardarropa": True, "zona_infantil": True},
    {"exclusividad": True, "alojamiento": True, "parking_vip": True},
    {"catering_propio": True, "dj_residente": True, "decoracion_floral": True},
    {"wifi": True, "proyector": True, "equipo_sonido": True},
    {"zona_chill_out": True, "barra_libre": True, "parking": True},
    {"alojamiento": True, "desayuno_invitados": True, "zona_spa": True},
    {"accesibilidad": True, "zona_fumadores": True, "parking": True},
    {"exclusividad": True, "piscina": True, "vestuarios": True},
    {"wifi": True, "cocina_show_cooking": True, "terraza": True},
    {"parking": True, "capilla": True, "alojamiento_novios": True},
    {"helipad": True, "seguridad_24h": True, "exclusividad": True},
    {"wifi": True, "accesibilidad": True, "zona_cocktail": True},
    {"personal_protocolo": True, "guardarropa": True, "parking": True},
    {"catering_opcional": True, "zona_baile": True, "alojamiento": True},
    {"proyeccion_exterior": True, "iluminacion_arquitectonica": True, "wifi": True},
    {"cocina_profesional": True, "camerinos": True, "ascensor": True},
    {"exclusividad": True, "parking": True, "alojamiento_invitados": True},
    {"zona_fotografias": True, "wifi": True, "personal_auxiliar": True},
    {"visitas_guiadas": True, "servicio_transporte": True, "accesibilidad": True},
    {"fuente_chocolate": True, "candy_bar": True, "animacion_infantil": True},
    {"servicio_audiovisual": True, "wifi": True, "azafatas": True},
    {"deportes_acuaticos": True, "embarcacion": True, "terraza_vistas": True},
    {"exclusividad": True, "helicoptero": True, "servicio_spa": True},
    {"accesibilidad": True, "parking": True, "catering_propio": True},
    {"coordinador_eventos": True, "wifi": True, "alojamiento_vip": True},
    {"visitas_culturales": True, "espacio_exposiciones": True, "accesibilidad": True},
    {"alojamiento": True, "desayuno_buffet": True, "servicio_habitaciones": True},
    {"camerinos": True, "escenario": True, "equipo_tecnico": True}
]

# Tipos de espacio
tipos_espai = ["FINCA", "HOTEL", "RESTAURANTE", "SALA", "JARDIN", "PLAYA", "CASTILLO"]

# Funciones auxiliares de ejemplo anterior
ciudades_provincias = [
    {"ciudad": "Barcelona", "provincia": "Barcelona", "codigo_postal": "08001"},
    {"ciudad": "Madrid", "provincia": "Madrid", "codigo_postal": "28001"},
    {"ciudad": "Valencia", "provincia": "Valencia", "codigo_postal": "46001"},
    {"ciudad": "Sevilla", "provincia": "Sevilla", "codigo_postal": "41001"},
    {"ciudad": "Zaragoza", "provincia": "Zaragoza", "codigo_postal": "50001"},
    {"ciudad": "Málaga", "provincia": "Málaga", "codigo_postal": "29001"},
    {"ciudad": "Bilbao", "provincia": "Vizcaya", "codigo_postal": "48001"},
    {"ciudad": "Alicante", "provincia": "Alicante", "codigo_postal": "03001"},
    {"ciudad": "Córdoba", "provincia": "Córdoba", "codigo_postal": "14001"},
    {"ciudad": "Valladolid", "provincia": "Valladolid", "codigo_postal": "47001"},
    {"ciudad": "Vigo", "provincia": "Pontevedra", "codigo_postal": "36201"},
    {"ciudad": "Gijón", "provincia": "Asturias", "codigo_postal": "33201"},
    {"ciudad": "Palma", "provincia": "Islas Baleares", "codigo_postal": "07001"},
    {"ciudad": "Las Palmas", "provincia": "Las Palmas", "codigo_postal": "35001"},
    {"ciudad": "Murcia", "provincia": "Murcia", "codigo_postal": "30001"},
    {"ciudad": "Sitges", "provincia": "Barcelona", "codigo_postal": "08870"},
    {"ciudad": "Marbella", "provincia": "Málaga", "codigo_postal": "29601"},
    {"ciudad": "San Sebastián", "provincia": "Guipúzcoa", "codigo_postal": "20001"},
    {"ciudad": "Toledo", "provincia": "Toledo", "codigo_postal": "45001"},
    {"ciudad": "Granada", "provincia": "Granada", "codigo_postal": "18001"}
]

calles = [
    "Calle Mayor", "Avenida Diagonal", "Plaza Catalunya", "Paseo de Gracia",
    "Calle Serrano", "Gran Vía", "Calle Alcalá", "Paseo del Prado",
    "Calle Colón", "Avenida del Puerto", "Plaza del Ayuntamiento", "Calle Ruzafa",
    "Avenida de la Constitución", "Calle Sierpes", "Plaza Nueva", "Calle Tetuán",
    "Paseo Independencia", "Plaza del Pilar", "Calle Alfonso", "Calle Don Jaime",
    "Calle Larios", "Plaza de la Merced", "Paseo del Parque", "Calle Granada",
    "Gran Vía de Don Diego López de Haro", "Plaza Circular", "Calle Ercilla", "Alameda Recalde",
    "Carretera de la Costa", "Camino del Monte", "Avenida del Mar", "Paseo Marítimo",
    "Urbanización Las Dunas", "Carretera del Faro", "Calle del Castillo", "Camino Rural"
]

disponibilidades = [
    ["L-V", "9:00-18:00"],
    ["L-S", "10:00-20:00"],
    ["L-D", "9:00-21:00"],
    ["L-V", "8:00-17:00"],
    ["L-S", "9:00-19:00"],
    ["M-S", "10:00-19:00"],
    ["X-D", "9:00-20:00"],
    ["J-D", "11:00-22:00"],
    ["V-D", "10:00-22:00"],
    ["V-D", "10:00-2:00"]
]

# Generar UUIDs consistentes basados en índice
def generar_uuid(indice: int, offset: int = 0) -> str:
    # Crear UUID predecible basado en índice
    base_uuid = f"d{indice+offset:04d}0000-0000-4000-d000-00000000{indice+offset:04d}"
    return base_uuid

# Función para generar ejemplos de espacios
def generar_espacios(cantidad: int) -> List[Dict[str, Any]]:
    espacios = []
    
    for i in range(cantidad):
        # Generar UUIDs para cada entidad relacionada
        servicio_id = generar_uuid(i, 1000)
        account_id = generar_uuid(i, 2000)
        espai_id = generar_uuid(i, 3000)
        
        # Seleccionar ciudad y provincia
        ciudad_provincia = random.choice(ciudades_provincias)
        
        # Determinar capacidad
        capacitat_min = random.randint(20, 80)
        capacitat_max = capacitat_min + random.randint(50, 400)
        
        # Generar servicio completo
        servicio = {
            "id": servicio_id,
            "type": "ESPAI",
            "name": random.choice(nombres_espai),
            "price": round(random.uniform(1500, 8000), 2),
            "images": [
                f"https://ejemplo.com/espai{i}_1.jpg",
                f"https://ejemplo.com/espai{i}_2.jpg",
                f"https://ejemplo.com/espai{i}_3.jpg",
                f"https://ejemplo.com/espai{i}_4.jpg"
            ],
            "description": random.choice(descripciones_espai),
            "availability": random.choice([True, True, True, False]),  # Mayor probabilidad de disponible
            "availability_rule": random.choice(disponibilidades),
            "services_extra": servicios_extra_espai[i % len(servicios_extra_espai)],
            "account_id": account_id,
            "address": {
                "direccion": f"{random.choice(calles)} {random.randint(1, 150)}",
                "ciudad": ciudad_provincia["ciudad"],
                "codigo_postal": ciudad_provincia["codigo_postal"],
                "provincia": ciudad_provincia["provincia"]
            },
            "espai": {
                "id": espai_id,
                "espai_type": random.choice(tipos_espai),
                "capacitat_min": capacitat_min,
                "capacitat_max": capacitat_max,
                "caracteristicas": random.sample(caracteristicas_espai, k=random.randint(4, 8))
            }
        }
        
        espacios.append(servicio)
    
    return espacios

# Generar los ejemplos
ejemplos_espai = generar_espacios(30)

# Guardar en un archivo JSON con formato legible
with open('ejemplos/espai.json', 'w', encoding='utf-8') as f:
    json.dump(ejemplos_espai, f, ensure_ascii=False, indent=2)

print(f"Se generaron {len(ejemplos_espai)} ejemplos de servicios de espacios")

# Para mostrar un ejemplo
print("\nEjemplo de servicio de espacio:")
print(json.dumps(ejemplos_espai[0], ensure_ascii=False, indent=2)) 