import json
import uuid
import random
from typing import List, Dict, Any

# Nombres para servicios de fotografía
nombres_fotografia = [
    "Fotografía Profesional para Bodas",
    "Servicio de Fotografía Premium para Eventos",
    "Fotografía Corporativa y Retratos",
    "Fotografía Editorial y Publicitaria",
    "Fotografía de Productos para E-commerce",
    "Fotógrafo Especializado en Eventos Sociales",
    "Fotografía Artística para Exposiciones",
    "Sesiones Fotográficas para Embarazadas",
    "Reportajes Fotográficos Documentales",
    "Fotografía Culinaria Profesional",
    "Book Fotográfico para Modelos",
    "Fotografía Arquitectónica Interior/Exterior",
    "Fotografía de Mascotas y Animales",
    "Fotografía Familiar en Estudio",
    "Servicios de Videografía y Fotografía",
    "Fotografía Deportiva Profesional",
    "Fotografía de Paisajes y Naturaleza",
    "Fotografía Nocturna y Timelapses",
    "Fotografía Aérea con Dron",
    "Fotografía para Redes Sociales",
    "Sesiones Fotográficas en Locaciones Exclusivas",
    "Fotografía para Portafolios Artísticos",
    "Fotoperiodismo para Eventos Especiales",
    "Fotografía de Festivales y Conciertos",
    "Fotografía para Catálogos de Moda",
    "Reportajes Fotográficos de Viajes",
    "Fotografía Minimalista y Conceptual",
    "Fotografía para Celebraciones Infantiles",
    "Servicios Completos de Fotografía Nupcial",
    "Fotografía de Propiedades Inmobiliarias"
]

# Descripciones para servicios de fotografía
descripciones_fotografia = [
    "Servicio completo de fotografía para bodas y eventos especiales",
    "Captamos los momentos más importantes de tu evento con calidad profesional",
    "Fotografía de alta calidad para empresas, productos y personal",
    "Servicios fotográficos especializados para campañas publicitarias",
    "Fotografía de productos con iluminación profesional para tiendas online",
    "Reportajes fotográficos para eventos sociales, cumpleaños y aniversarios",
    "Creación de obras fotográficas artísticas para galerías y exposiciones",
    "Sesiones fotográficas para embarazadas en estudio o exteriores",
    "Documentación fotográfica de eventos históricos o culturales",
    "Fotografía especializada para restaurantes, chefs y productos gastronómicos",
    "Sesiones profesionales para modelos, actores y portfolios artísticos",
    "Fotografía arquitectónica para proyectos, constructoras y estudios de diseño",
    "Sesiones fotográficas especializadas para mascotas y animales",
    "Retratos familiares en estudio con iluminación controlada",
    "Servicios combinados de video y fotografía para eventos especiales",
    "Fotografía deportiva para competiciones, torneos y eventos",
    "Captura de paisajes naturales y urbanos con equipo especializado",
    "Técnicas especiales de fotografía nocturna y secuencias time-lapse",
    "Fotografía aérea mediante drones para eventos, propiedades y paisajes",
    "Creación de contenido fotográfico optimizado para redes sociales",
    "Sesiones fotográficas en locaciones exclusivas y de difícil acceso",
    "Fotografía para artistas, músicos y creativos con enfoque artístico",
    "Cobertura periodística de eventos, manifestaciones y sucesos relevantes",
    "Fotografía profesional para festivales de música, conciertos y actuaciones",
    "Creación de imágenes para catálogos de moda y lookbooks",
    "Documentación fotográfica de viajes y destinos turísticos",
    "Fotografía conceptual y minimalista para proyectos artísticos",
    "Fotografía especializada en fiestas infantiles, comuniones y bautizos",
    "Paquete completo para bodas: preboda, ceremonia, postboda y álbum",
    "Fotografía inmobiliaria para agencias, portales y particulares"
]

# Características para servicios de fotografía
caracteristicas_fotografia = [
    "Edición profesional",
    "Entrega en 15 días",
    "Formato RAW incluido",
    "Impresiones en papel fotográfico",
    "Álbum digital personalizado",
    "Sesión previa para planificación",
    "Selección de mejores tomas",
    "Retoque avanzado",
    "Copias en alta resolución",
    "Galería online privada",
    "Entrega en pendrive personalizado",
    "Edición de color profesional",
    "Backup garantizado por 1 año",
    "Segundo fotógrafo incluido",
    "Iluminación de estudio portátil",
    "Drones para tomas aéreas",
    "Impresión fine art disponible",
    "Book impreso de muestra",
    "Atrezzo y decorados incluidos",
    "Maquillaje profesional opcional",
    "Vestuario y cambios de ropa",
    "Asesoramiento de imagen",
    "Álbum físico de gran formato",
    "Vídeo behind the scenes",
    "Entrega express disponible",
    "Fotografía en blanco y negro",
    "Técnicas de iluminación avanzadas",
    "Fotografía submarina disponible",
    "Estudio móvil para eventos",
    "Cámaras de respaldo garantizadas"
]

# Servicios extra para fotografía
servicios_extra_fotografia = [
    {"album_digital": True, "impresiones": 100, "sesion_preboda": True},
    {"album_digital": True, "video_resumen": True, "photocall": True},
    {"impresiones": 50, "sesion_estudio": True, "album_fisico": True},
    {"retoque_avanzado": True, "album_digital": True, "copias_familia": True},
    {"maquillaje_profesional": True, "album_digital": True, "video_corto": True},
    {"sesion_preboda": True, "album_digital": True, "impresiones": 200},
    {"photocall": True, "props_divertidos": True, "album_digital": True},
    {"album_fisico": True, "video_drone": True, "lienzo_gran_formato": True},
    {"impresiones": 150, "album_digital": True, "copia_raw": True},
    {"sesion_postboda": True, "album_digital": True, "impresiones": 100},
    {"segundo_fotografo": True, "album_digital": True, "video_resumen": True},
    {"impresiones": 75, "album_fisico": True, "entrega_express": True},
    {"album_digital": True, "copias_familia": True, "sesion_trash_dress": True},
    {"impresiones": 50, "album_fisico": True, "fotolibro_padres": True},
    {"album_digital": True, "impresiones": 100, "video_testimonio": True},
    {"sesion_boudoir": True, "album_digital": True, "impresiones": 25},
    {"album_fisico": True, "copias_hd": True, "video_resumen": True},
    {"impresiones": 100, "copia_raw": True, "photocall": True},
    {"video_drone": True, "album_digital": True, "impresiones": 150},
    {"album_fisico": True, "sesion_preboda": True, "impresiones": 100},
    {"impresiones": 200, "album_digital": True, "video_resumen": True},
    {"entrega_express": True, "album_digital": True, "photocall": True},
    {"album_fisico": True, "copia_raw": True, "impresiones": 100},
    {"video_resumen": True, "album_digital": True, "impresiones": 50},
    {"sesion_preboda": True, "album_fisico": True, "photocall": True},
    {"album_digital": True, "impresiones": 150, "fotolibro_padres": True},
    {"video_drone": True, "album_fisico": True, "sesion_postboda": True},
    {"album_digital": True, "impresiones": 100, "segundo_fotografo": True},
    {"copia_raw": True, "album_fisico": True, "video_resumen": True},
    {"impresiones": 200, "album_digital": True, "sesion_preboda": True}
]

# Ciudades y provincias
ciudades_provincias = [
    {"ciudad": "Barcelona", "provincia": "Barcelona", "codigo_postal": "08001"},
    {"ciudad": "Madrid", "provincia": "Madrid", "codigo_postal": "28001"},
    {"ciudad": "Valencia", "provincia": "Valencia", "codigo_postal": "46001"},
    {"ciudad": "Sevilla", "provincia": "Sevilla", "codigo_postal": "41001"},
    {"ciudad": "Zaragoza", "provincia": "Zaragoza", "codigo_postal": "50001"},
    {"ciudad": "Málaga", "provincia": "Málaga", "codigo_postal": "29001"},
    {"ciudad": "Bilbao", "provincia": "Vizcaya", "codigo_postal": "48001"},
    {"ciudad": "Alicante", "provincia": "Alicante", "codigo_postal": "03001"},
    {"ciudad": "Córdoba", "provincia": "Córdoba", "codigo_postal": "14001"},
    {"ciudad": "Valladolid", "provincia": "Valladolid", "codigo_postal": "47001"},
    {"ciudad": "Vigo", "provincia": "Pontevedra", "codigo_postal": "36201"},
    {"ciudad": "Gijón", "provincia": "Asturias", "codigo_postal": "33201"},
    {"ciudad": "Palma", "provincia": "Islas Baleares", "codigo_postal": "07001"},
    {"ciudad": "Las Palmas", "provincia": "Las Palmas", "codigo_postal": "35001"},
    {"ciudad": "Murcia", "provincia": "Murcia", "codigo_postal": "30001"}
]

# Nombres de calles
calles = [
    "Calle Mayor", "Avenida Diagonal", "Plaza Catalunya", "Paseo de Gracia",
    "Calle Serrano", "Gran Vía", "Calle Alcalá", "Paseo del Prado",
    "Calle Colón", "Avenida del Puerto", "Plaza del Ayuntamiento", "Calle Ruzafa",
    "Avenida de la Constitución", "Calle Sierpes", "Plaza Nueva", "Calle Tetuán",
    "Paseo Independencia", "Plaza del Pilar", "Calle Alfonso", "Calle Don Jaime",
    "Calle Larios", "Plaza de la Merced", "Paseo del Parque", "Calle Granada",
    "Gran Vía de Don Diego López de Haro", "Plaza Circular", "Calle Ercilla", "Alameda Recalde"
]

# Condiciones para el raider
condiciones_raider = [
    "Zona techada para equipos",
    "Acceso a electricidad",
    "Comida para el equipo en eventos >6h",
    "Estacionamiento cercano al lugar",
    "Agua potable disponible",
    "Área de descanso para el equipo",
    "Acceso previo al lugar para preparación",
    "Puntos de carga para equipos electrónicos",
    "Iluminación básica en el lugar",
    "Persona de contacto durante todo el evento",
    "Wi-Fi disponible para transferencia de archivos",
    "Protección contra lluvia para equipos",
    "Tiempo para comidas",
    "Transporte de equipos pesados",
    "Seguridad para el equipo fotográfico"
]

# Roles para integrantes del equipo
roles_equipo = [
    "Fotógrafo principal", "Fotógrafo secundario", "Asistente", "Editor",
    "Iluminador", "Estilista", "Drone operator", "Director artístico",
    "Maquillador", "Coordinador", "Técnico de iluminación", "Operador de video"
]

# Nombres de personas
nombres_personas = [
    "Ana García", "Miguel López", "Carlos Ruiz", "Laura Martínez",
    "David Fernández", "Elena Sánchez", "Javier Rodríguez", "María Torres",
    "Pablo Navarro", "Sofía Ramírez", "Alejandro Díaz", "Lucía Hernández",
    "Daniel Jiménez", "Clara Moreno", "Roberto Álvarez", "Carmen Gutiérrez",
    "Francisco Romero", "Isabel Serrano", "Antonio Molina", "Cristina Ortega",
    "Sergio Gil", "Marta Blanco", "José Delgado", "Raquel Herrera",
    "Enrique Méndez", "Victoria Castro", "Rubén Sáez", "Natalia Reyes",
    "Alberto Cruz", "Beatriz Flores", "Fernando Vega", "Alicia Pascual"
]

# Disponibilidades
disponibilidades = [
    ["L-V", "9:00-18:00"],
    ["L-S", "10:00-20:00"],
    ["L-D", "9:00-21:00"],
    ["L-V", "8:00-17:00"],
    ["L-S", "9:00-19:00"],
    ["M-S", "10:00-19:00"],
    ["X-D", "9:00-20:00"],
    ["J-D", "11:00-22:00"],
    ["V-D", "10:00-22:00"],
    ["L-D", "8:00-18:00"]
]

# Generar UUIDs consistentes basados en índice
def generar_uuid(indice: int, offset: int = 0) -> str:
    # Crear UUID predecible basado en índice
    base_uuid = f"a{indice+offset:04d}0000-0000-4000-a000-00000000{indice+offset:04d}"
    return base_uuid

# Función para generar ejemplos de fotografía
def generar_fotografias(cantidad: int) -> List[Dict[str, Any]]:
    fotografias = []
    
    for i in range(cantidad):
        # Generar UUIDs para cada entidad relacionada
        servicio_id = generar_uuid(i, 1000)
        account_id = generar_uuid(i, 2000)
        fotografia_id = generar_uuid(i, 3000)
        raider_id = generar_uuid(i, 4000)
        
        # Seleccionar ciudad y provincia
        ciudad_provincia = random.choice(ciudades_provincias)
        
        # Generar equipo de fotografía
        num_integrantes = random.randint(1, 5)
        equipo = []
        for j in range(num_integrantes):
            equipo.append({
                "nombre": random.choice(nombres_personas),
                "rol": random.choice(roles_equipo)
            })
        
        # Generar servicio completo
        servicio = {
            "id": servicio_id,
            "type": "FOTOGRAFIA",
            "name": random.choice(nombres_fotografia),
            "price": round(random.uniform(800, 3000), 2),
            "images": [
                f"https://ejemplo.com/fotografia{i}_1.jpg",
                f"https://ejemplo.com/fotografia{i}_2.jpg",
                f"https://ejemplo.com/fotografia{i}_3.jpg"
            ],
            "description": random.choice(descripciones_fotografia),
            "availability": random.choice([True, True, True, False]),  # Mayor probabilidad de disponible
            "availability_rule": random.choice(disponibilidades),
            "services_extra": servicios_extra_fotografia[i % len(servicios_extra_fotografia)],
            "account_id": account_id,
            "address": {
                "direccion": f"{random.choice(calles)} {random.randint(1, 150)}",
                "ciudad": ciudad_provincia["ciudad"],
                "codigo_postal": ciudad_provincia["codigo_postal"],
                "provincia": ciudad_provincia["provincia"]
            },
            "fotografia": {
                "id": fotografia_id,
                "fotografia_type": "FOTOGRAFIA",
                "servicio_especial_type": random.choice([None, "ESPEJO_MAGICO", "VIDEOCABINA", "DRON"]),
                "duracion": round(random.uniform(2, 8), 1),
                "caracteristicas": random.sample(caracteristicas_fotografia, k=random.randint(3, 5)),
                "raider_id": raider_id,
                "raider": {
                    "id": raider_id,
                    "num_integrantes": num_integrantes,
                    "equipo": equipo,
                    "equipo_propio": random.choice([True, True, False]),
                    "coste_equipo_propio": round(random.uniform(0, 300), 2) if random.choice([True, True, False]) else 0.0,
                    "disponible_sin_equipo": random.choice([True, False]),
                    "dimensiones_escenario": {
                        "ancho": round(random.uniform(2, 5), 1),
                        "largo": round(random.uniform(2, 6), 1),
                        "alto": round(random.uniform(1, 3), 1)
                    },
                    "condiciones": random.sample(condiciones_raider, k=random.randint(2, 4))
                }
            }
        }
        
        fotografias.append(servicio)
    
    return fotografias

# Generar los ejemplos
ejemplos_fotografia = generar_fotografias(30)

# Guardar en un archivo JSON con formato legible
import os

if not os.path.exists('ejemplos'):
    os.makedirs('ejemplos')

with open('ejemplos/fotografias.json', 'w', encoding='utf-8') as f:
    json.dump(ejemplos_fotografia, f, ensure_ascii=False, indent=2)

print(f"Se generaron {len(ejemplos_fotografia)} ejemplos de servicios de fotografía")

# Para mostrar un ejemplo
print("\nEjemplo de servicio de fotografía:")
print(json.dumps(ejemplos_fotografia[0], ensure_ascii=False, indent=2)) 