import json
import random
from typing import List, Dict, Any

# Nombres para servicios de mobiliario
nombres_mobiliari = [
    "Mesas y Sillas Premium",
    "Mobiliario Vintage para Eventos",
    "Conjunto Elegante para Celebraciones",
    "Mobiliario Minimalista Moderno",
    "Mesas Imperiales con Decoración",
    "Sillas Tiffany y Mesas Redondas",
    "Mobiliario Rústico para Eventos",
    "Equipamiento Completo para Bodas",
    "Mobiliario de Diseño Exclusivo",
    "Sillas Crossback y Mesas de Madera",
    "Conjuntos de Mobiliario para Carpas",
    "Butacas y Mesas para Eventos Formales",
    "Mobiliario de Exterior Premium",
    "Equipo Completo para Banquetes",
    "Mesas Altas y Taburetes de Diseño",
    "Conjuntos Lounge para Eventos",
    "Mesas de Presidencia y Protocolo",
    "Sillas Ghost y Mesas de Cristal",
    "Mobiliario para Bodas en Playa",
    "Set Completo para Fiestas y Eventos",
    "Mesas de Buffet y Catering",
    "Sillas Premium y Mesas a Juego",
    "Mobiliario de Estilo Nórdico",
    "Conjuntos Clásicos para Ceremonias",
    "Mobiliario Industrial para Eventos",
    "Mesas Rectangulares y Sillas Chiavari",
    "Equipamiento para Congresos y Reuniones",
    "Mobiliario Elegante para Banquetes",
    "Conjunto de Mesas para Cóctel",
    "Mobiliario Modular para Eventos"
]

# Descripciones para servicios de mobiliario
descripciones_mobiliari = [
    "Mobiliario elegante para eventos corporativos y bodas",
    "Muebles vintage con encanto para celebraciones con estilo",
    "Conjunto completo de mobiliario elegante para todo tipo de celebraciones",
    "Mobiliario de líneas minimalistas y modernas para eventos contemporáneos",
    "Mesas imperiales con detalles decorativos para celebraciones especiales",
    "Clásicas sillas Tiffany y mesas redondas para bodas y eventos",
    "Mobiliario con encanto rústico para eventos en espacios naturales",
    "Equipamiento completo de mobiliario y complementos para bodas",
    "Piezas exclusivas de diseño para eventos de alto standing",
    "Combinación de sillas crossback y mesas de madera para eventos con encanto",
    "Conjuntos integrales para equipar carpas y espacios temporales",
    "Mobiliario formal y elegante para eventos corporativos y galas",
    "Soluciones de mobiliario resistente para celebraciones en exteriores",
    "Equipamiento completo para banquetes de cualquier tamaño",
    "Mesas altas y taburetes para zonas de cóctel y networking",
    "Conjuntos de mobiliario lounge para crear espacios de relax en eventos",
    "Mesas de presidencia y protocolo para eventos formales y oficiales",
    "Elegantes sillas transparentes Ghost y mesas de cristal para eventos exclusivos",
    "Mobiliario especializado para celebraciones en entornos de playa",
    "Set completo con todo lo necesario para equipar fiestas y celebraciones",
    "Mesas especiales para montaje de buffets y servicios de catering",
    "Sillas de alta calidad con mesas a juego para eventos premium",
    "Mobiliario con el inconfundible estilo nórdico para eventos modernos",
    "Conjuntos de mobiliario clásico para ceremonias tradicionales",
    "Mobiliario de estilo industrial para eventos en espacios alternativos",
    "Combinación perfecta de mesas rectangulares y las populares sillas Chiavari",
    "Equipamiento especializado para congresos, conferencias y reuniones",
    "Mobiliario de alta gama para banquetes y celebraciones exclusivas",
    "Conjunto especializado de mesas para servicios de cóctel y aperitivos",
    "Sistema modular de mobiliario adaptable a cualquier tipo de evento y espacio"
]

# Características para servicios de mobiliario
caracteristicas_mobiliari = [
    "Plegable",
    "Resistente a exteriores",
    "Fácil limpieza",
    "Apilable",
    "Ergonómico",
    "Ignífugo",
    "Personalizable",
    "Ajustable en altura",
    "Impermeable",
    "Alta durabilidad",
    "Peso ligero",
    "Fácil transporte",
    "Modular",
    "Resistente a UV",
    "Acabado premium",
    "Diseño ergonómico",
    "Antideslizante",
    "Elegante",
    "Reclinable",
    "Gran estabilidad",
    "Fácil montaje",
    "Resistente a impactos",
    "Con certificación de calidad",
    "Ecológico",
    "Diseño exclusivo",
    "Acabado artesanal",
    "Extensible",
    "Material de alta calidad",
    "Resistente a manchas",
    "Confort premium"
]

# Colores para mobiliario
colores_mobiliari = [
    "blanco", "negro", "natural", "dorado", "plateado", "madera", "caoba",
    "marfil", "gris", "nogal", "cristal", "transparente", "azul", "verde",
    "rojo", "rosa", "morado", "beige", "turquesa", "coral", "champán",
    "burdeos", "chocolate", "amarillo", "naranja", "oliva", "topo", "antracita"
]

# Materiales para mobiliario
materiales_mobiliari = [
    "madera maciza", "acero inoxidable", "hierro forjado", "aluminio", "ratán",
    "polipropileno", "policarbonato", "cristal templado", "madera de pino",
    "terciopelo", "polietileno", "metacrilato", "fibra sintética", "MDF lacado",
    "madera de teca", "plástico reforzado", "madera de roble", "metal y madera",
    "resina", "bambú", "formica", "vinilo", "cuero", "poliuretano", "acrílico"
]

# Estilos para mobiliario
estilos_mobiliari = [
    "Moderno", "Clásico", "Vintage", "Industrial", "Rústico",
    "Nórdico", "Minimalista", "Romántico", "Bohemio", "Art Deco",
    "Contemporáneo", "Provenzal", "Escandinavo", "Colonial", "Ecléctico",
    "Mid-Century", "Barroco", "Shabby Chic", "Loft", "Mediterráneo"
]

# Tamaños para mobiliario
tamaños_mobiliari = [
    "Grande", "Mediano", "Pequeño", "2m x 1m", "1.5m x 1m",
    "80cm x 80cm", "60cm x 60cm", "180cm diámetro", "150cm diámetro",
    "120cm diámetro", "110cm x 220cm", "75cm x 150cm", "45cm x 45cm",
    "200cm x 100cm", "240cm x 120cm", "75cm alto", "110cm alto", 
    "Estándar", "Ajustable", "Personalizable"
]

# Tipologías para mobiliario
tipologias_mobiliari = [
    "MESAS", "SILLAS", "CARPAS", "TARIMAS",
    "BARRAS", "ESTANTERIAS", "ILUMINACION"
]

# Formas para mobiliario
formas_mobiliari = [
    "Rectangular", "Redonda", "Cuadrada", "Ovalada", "Imperial",
    "Triangular", "Semicircular", "Modular", "Hexagonal", "Irregular"
]

# Modalidades para mobiliario
modalidades_mobiliari = [
    "Banquete", "Cóctel", "Reunión", "Exposición", "Ceremonia",
    "Buffet", "Conferencia", "Escuela", "Teatro", "Recepción"
]

# Servicios extra para mobiliario
servicios_extra_mobiliari = [
    {"montaje_incluido": True, "desmontaje_incluido": True, "transporte_incluido": True},
    {"transporte_incluido": True, "personal_montaje": True, "seguro_daños": True},
    {"limpieza_posterior": True, "visita_previa": True, "descarga_incluida": True},
    {"montaje_incluido": True, "mantenimiento": True, "recogida_24h": True},
    {"personal_especializado": True, "transporte_incluido": True, "reposición": True},
    {"seguro_incluido": True, "montaje_incluido": True, "limpieza_posterior": True},
    {"asesoramiento_decorativo": True, "montaje_anticipado": True, "desmontaje_incluido": True},
    {"transporte_incluido": True, "embalaje_protector": True, "asistencia_técnica": True},
    {"planos_distribución": True, "montaje_incluido": True, "desmontaje_incluido": True},
    {"atención_urgencias": True, "montaje_nocturno": True, "stock_garantizado": True},
    {"asesoramiento_integral": True, "transporte_incluido": True, "materiales_calidad": True},
    {"montaje_incluido": True, "desmontaje_incluido": True, "coordinación_proveedores": True},
    {"asistencia_evento": True, "prueba_previa": True, "transporte_incluido": True},
    {"montaje_rápido": True, "sistema_modular": True, "desmontaje_incluido": True},
    {"personal_uniformado": True, "transporte_incluido": True, "embalaje_individual": True},
    {"montaje_incluido": True, "sustitución_inmediata": True, "mantenimiento_evento": True},
    {"supervisión_técnica": True, "transporte_incluido": True, "asesoramiento_técnico": True},
    {"calidad_premium": True, "montaje_incluido": True, "desmontaje_incluido": True},
    {"transporte_incluido": True, "elementos_decorativos": True, "limpieza_posterior": True},
    {"montaje_incluido": True, "stock_extra": True, "desmontaje_rapido": True},
    {"seguro_responsabilidad": True, "transporte_incluido": True, "instaladores_profesionales": True},
    {"montaje_incluido": True, "desmontaje_incluido": True, "adaptación_espacio": True},
    {"planificación_integral": True, "transporte_incluido": True, "servicio_24h": True},
    {"montaje_incluido": True, "coordinación_evento": True, "material_calidad": True},
    {"transporte_incluido": True, "elementos_complementarios": True, "diseño_personalizado": True},
    {"montaje_incluido": True, "desmontaje_incluido": True, "transporte_incluido": True},
    {"sistema_integral": True, "embalaje_seguro": True, "transporte_incluido": True},
    {"montaje_incluido": True, "supervisión_continua": True, "desmontaje_incluido": True},
    {"transporte_incluido": True, "seguro_daños": True, "adaptación_terreno": True},
    {"montaje_premium": True, "desmontaje_incluido": True, "transporte_incluido": True}
]

# Funciones auxiliares de ejemplos anteriores
ciudades_provincias = [
    {"ciudad": "Barcelona", "provincia": "Barcelona", "codigo_postal": "08001"},
    {"ciudad": "Madrid", "provincia": "Madrid", "codigo_postal": "28001"},
    {"ciudad": "Valencia", "provincia": "Valencia", "codigo_postal": "46001"},
    {"ciudad": "Sevilla", "provincia": "Sevilla", "codigo_postal": "41001"},
    {"ciudad": "Zaragoza", "provincia": "Zaragoza", "codigo_postal": "50001"},
    {"ciudad": "Málaga", "provincia": "Málaga", "codigo_postal": "29001"},
    {"ciudad": "Bilbao", "provincia": "Vizcaya", "codigo_postal": "48001"},
    {"ciudad": "Alicante", "provincia": "Alicante", "codigo_postal": "03001"},
    {"ciudad": "Córdoba", "provincia": "Córdoba", "codigo_postal": "14001"},
    {"ciudad": "Valladolid", "provincia": "Valladolid", "codigo_postal": "47001"},
    {"ciudad": "Vigo", "provincia": "Pontevedra", "codigo_postal": "36201"},
    {"ciudad": "Gijón", "provincia": "Asturias", "codigo_postal": "33201"},
    {"ciudad": "Palma", "provincia": "Islas Baleares", "codigo_postal": "07001"},
    {"ciudad": "Las Palmas", "provincia": "Las Palmas", "codigo_postal": "35001"},
    {"ciudad": "Murcia", "provincia": "Murcia", "codigo_postal": "30001"}
]

calles = [
    "Calle Mayor", "Avenida Diagonal", "Plaza Catalunya", "Paseo de Gracia",
    "Calle Serrano", "Gran Vía", "Calle Alcalá", "Paseo del Prado",
    "Calle Colón", "Avenida del Puerto", "Plaza del Ayuntamiento", "Calle Ruzafa",
    "Avenida de la Constitución", "Calle Sierpes", "Plaza Nueva", "Calle Tetuán",
    "Paseo Independencia", "Plaza del Pilar", "Calle Alfonso", "Calle Don Jaime",
    "Calle Larios", "Plaza de la Merced", "Paseo del Parque", "Calle Granada",
    "Gran Vía de Don Diego López de Haro", "Plaza Circular", "Calle Ercilla", "Alameda Recalde"
]

disponibilidades = [
    ["L-V", "9:00-18:00"],
    ["L-S", "10:00-20:00"],
    ["L-D", "9:00-21:00"],
    ["L-V", "8:00-17:00"],
    ["L-S", "9:00-19:00"],
    ["M-S", "10:00-19:00"],
    ["X-D", "9:00-20:00"],
    ["J-D", "11:00-22:00"],
    ["V-D", "10:00-22:00"],
    ["L-D", "8:00-20:00"]
]

# Generar UUIDs consistentes basados en índice
def generar_uuid(indice: int, offset: int = 0) -> str:
    # Crear UUID predecible basado en índice
    base_uuid = f"e{indice+offset:04d}0000-0000-4000-e000-00000000{indice+offset:04d}"
    return base_uuid

# Función para generar ejemplos de mobiliario
def generar_mobiliario(cantidad: int) -> List[Dict[str, Any]]:
    mobiliario = []
    
    for i in range(cantidad):
        # Generar UUIDs para cada entidad relacionada
        servicio_id = generar_uuid(i, 1000)
        account_id = generar_uuid(i, 2000)
        mobiliari_id = generar_uuid(i, 3000)
        
        # Seleccionar ciudad y provincia
        ciudad_provincia = random.choice(ciudades_provincias)
        
        # Determinar capacidad y tipología
        tipologia = random.choice(tipologias_mobiliari)
        cantidad_min = random.randint(5, 20)
        cantidad_max = cantidad_min + random.randint(20, 100)
        
        # Generar servicio completo
        servicio = {
            "id": servicio_id,
            "type": "MOBILIARI_DECORACIO",
            "name": random.choice(nombres_mobiliari),
            "price": round(random.uniform(500, 3000), 2),
            "images": [
                f"https://ejemplo.com/mobiliari{i}_1.jpg",
                f"https://ejemplo.com/mobiliari{i}_2.jpg"
            ],
            "description": random.choice(descripciones_mobiliari),
            "availability": random.choice([True, True, True, False]),  # Mayor probabilidad de disponible
            "availability_rule": random.choice(disponibilidades),
            "services_extra": servicios_extra_mobiliari[i % len(servicios_extra_mobiliari)],
            "account_id": account_id,
            "address": {
                "direccion": f"{random.choice(calles)} {random.randint(1, 150)}",
                "ciudad": ciudad_provincia["ciudad"],
                "codigo_postal": ciudad_provincia["codigo_postal"],
                "provincia": ciudad_provincia["provincia"]
            },
            "mobiliari_decoracio": {
                "id": mobiliari_id,
                "service_type": "MOBILIARIO",
                "tipologia": tipologia,
                "is_rental": random.choice([True, True, False]),  # Mayor probabilidad de alquiler
                "cantidad_min": cantidad_min,
                "cantidad_max": cantidad_max,
                "subtipologia": f"{random.choice(['Mesa', 'Silla', 'Sofá', 'Taburete', 'Barra'])} {random.choice(['premium', 'clásico', 'moderno', 'vintage', 'exclusivo'])}",
                "forma": random.choice(formas_mobiliari),
                "modality": random.choice(modalidades_mobiliari),
                "color": random.sample(colores_mobiliari, k=random.randint(1, 4)),
                "material": random.sample(materiales_mobiliari, k=random.randint(1, 3)),
                "style": random.choice(estilos_mobiliari),
                "size": random.choice(tamaños_mobiliari),
                "caracteristicas": random.sample(caracteristicas_mobiliari, k=random.randint(3, 5)),
                "complement": random.choice([None, "Cojines incluidos", "Protectores de suelo incluidos", "Fundas opcionales", "Kit de limpieza incluido"]),
                "dimensiones": {
                    "width": random.randint(40, 250) * 1.0,
                    "height": random.randint(40, 120) * 1.0,
                    "depth": random.randint(30, 120) * 1.0
                }
            }
        }
        
        mobiliario.append(servicio)
    
    return mobiliario

# Generar los ejemplos
ejemplos_mobiliario = generar_mobiliario(15)  # Generar 15 ejemplos de mobiliario

# Guardar en un archivo JSON con formato legible
with open('ejemplos/mobiliari.json', 'w', encoding='utf-8') as f:
    json.dump(ejemplos_mobiliario, f, ensure_ascii=False, indent=2)

# Para mostrar un ejemplo
print(f"Se generaron {len(ejemplos_mobiliario)} ejemplos de servicios de mobiliario")
print("\nEjemplo de servicio de mobiliario:")
print(json.dumps(ejemplos_mobiliario[0], ensure_ascii=False, indent=2)) 