import json
import random
from typing import List, Dict, Any

# Nombres para servicios de música
nombres_musica = [
    "DJ Eventos Premium",
    "Grupo Musical Bodas y Eventos",
    "Orquesta Completa para Celebraciones",
    "Cantante Solista con Repertorio Variado",
    "DJ y Animación para Fiestas",
    "Banda de Jazz para Eventos",
    "Trío Musical Cocktail y Ceremonias",
    "DJ Especializado en Música Electrónica",
    "Grupo de Versiones Pop-Rock",
    "Música Clásica para Eventos Elegantes",
    "DJ con Equipo Completo Profesional",
    "Grupo Flamenco para Eventos",
    "Mariachi Profesional para Celebraciones",
    "Música Ambiental para Eventos Corporativos",
    "DJ con Saxofonista en Directo",
    "Banda de Blues y Soul",
    "Violinista para Ceremonias",
    "Cuarteto de Cuerda para Eventos",
    "DJ Especializado en Bodas",
    "Grupo Versátil con Repertorio Internacional",
    "Cantautores para Eventos Íntimos",
    "Dúo de Guitarra y Voz",
    "Banda de Covers para Fiestas",
    "DJ y Percusionista en Directo",
    "Charanga para Animación de Eventos",
    "Banda de Música Latina",
    "Cantantes Líricos para Ceremonias",
    "DJ con Efectos Visuales y Luces",
    "Grupo Acústico para Cócteles",
    "Música Tradicional para Eventos Culturales"
]

# Descripciones para servicios de música
descripciones_musica = [
    "DJ profesional con equipo completo para eventos y bodas",
    "Grupo musical versátil para amenizar todo tipo de celebraciones",
    "Orquesta completa con vocalistas para una experiencia musical única",
    "Cantante profesional con amplio repertorio para momentos especiales",
    "DJ con servicios de animación para fiestas memorables",
    "Banda de jazz elegante para ambientar eventos exclusivos",
    "Trio musical ideal para ceremonias y cócteles",
    "DJ especializado en música electrónica para eventos modernos",
    "Grupo musical con los mejores éxitos del pop y rock de todos los tiempos",
    "Conjunto de música clásica para dar elegancia a cualquier evento",
    "DJ profesional con equipo de sonido e iluminación de alta gama",
    "Grupo flamenco auténtico para dar un toque especial a tus eventos",
    "Mariachi tradicional para momentos inolvidables",
    "Música ambiental seleccionada para eventos empresariales",
    "Combinación única de DJ con saxofonista en directo",
    "Banda de blues y soul con un sonido auténtico y potente",
    "Violinista profesional especializado en ceremonias",
    "Cuarteto de cuerda clásico para eventos distinguidos",
    "DJ especializado en bodas con experiencia en protocolos",
    "Grupo musical con repertorio internacional para todos los gustos",
    "Cantautores con temas propios y versiones para eventos íntimos",
    "Dúo musical con guitarra y voz para momentos especiales",
    "Banda de versiones con los éxitos más bailables",
    "Fusión de DJ con percusionista para ritmos únicos",
    "Charanga divertida para animar cualquier tipo de celebración",
    "Banda especializada en música latina y ritmos bailables",
    "Cantantes de ópera y zarzuela para ceremonias distinguidas",
    "DJ con espectáculo completo de luces y efectos visuales",
    "Grupo acústico ideal para ambientar cócteles y recepciones",
    "Música tradicional para eventos con sabor cultural"
]

# Características para servicios de música
caracteristicas_musica = [
    "Iluminación profesional",
    "Efectos especiales",
    "Lista personalizada",
    "Repertorio adaptable",
    "Equipo de sonido profesional",
    "Músicos profesionales",
    "Desplazamiento incluido",
    "Montaje y desmontaje",
    "Coordinación con el evento",
    "Vestuario formal",
    "Puntualidad garantizada",
    "Experiencia en bodas",
    "Amplio repertorio",
    "Equipo de backup",
    "Técnico de sonido incluido",
    "Adaptabilidad a espacios",
    "Micrófonos inalámbricos",
    "Música en pausas",
    "Animación del público",
    "Multilingüe",
    "Conocimiento de protocolos",
    "Interacción con invitados",
    "Versatilidad de estilos",
    "Transiciones profesionales",
    "Personalización de espectáculo",
    "Adaptación del volumen",
    "Planificación previa",
    "Grabación del evento",
    "Maestro de ceremonias",
    "Efectos de luz sincronizados"
]

# Servicios extra para música
servicios_extra_musica = [
    {"incluye_luces": True, "animacion": True, "maquina_humo": True},
    {"karaoke": True, "photocall": True, "videoproyeccion": True},
    {"instrumentos_extra": True, "repertorio_personalizado": True, "tecnico_sonido": True},
    {"grabacion_audio": True, "montaje_anticipado": True, "equipo_reserva": True},
    {"efectos_especiales": True, "iluminacion_decorativa": True, "personalización_escenario": True},
    {"vestuario_tematico": True, "coordinacion_baile": True, "ensayo_previo": True},
    {"fotografo_incluido": True, "video_resumen": True, "photocall": True},
    {"animador_profesional": True, "espectaculo_luces": True, "maquina_humo": True},
    {"repertorio_ceremonias": True, "entrada_novios": True, "primer_baile": True},
    {"microfonia_extra": True, "asistente_coordinacion": True, "equipo_reserva": True},
    {"pantallas_led": True, "proyeccion_videos": True, "mapping": True},
    {"instrumentos_acusticos": True, "amplificacion_profesional": True, "monitores": True},
    {"efectos_confeti": True, "pirotecnia_fria": True, "co2": True},
    {"masterizacion_evento": True, "video_recuerdo": True, "album_digital": True},
    {"espectaculo_bailarines": True, "coreografias": True, "interaccion_publico": True},
    {"maquillaje_caracterizacion": True, "vestuario_tematico": True, "elementos_decorativos": True},
    {"set_personalizado": True, "mashups_exclusivos": True, "remix_personalizados": True},
    {"instrumentos_vintage": True, "amplificacion_valvulas": True, "sonido_analogico": True},
    {"equipo_movil": True, "desplazamiento_largo": True, "montaje_anticipado": True},
    {"repertorio_internacional": True, "cantante_multilingue": True, "maestro_ceremonias": True},
    {"equipo_alta_gama": True, "tecnicos_certificados": True, "sistema_backup": True},
    {"asesoramiento_musical": True, "reunion_previa": True, "visita_tecnica": True},
    {"streaming_directo": True, "grabacion_multicanal": True, "edicion_profesional": True},
    {"coordinacion_proveedores": True, "temporizacion_evento": True, "asistente_dedicado": True},
    {"interpretacion_solicitada": True, "ensayos_extras": True, "cancion_personalizada": True},
    {"efectos_laser": True, "iluminacion_arquitectonica": True, "escenario_tematico": True},
    {"montaje_premium": True, "estructuras_truss": True, "tarimas_escenario": True},
    {"equipo_hibrido": True, "instrumentos_electronicos": True, "loopstation": True},
    {"backline_completo": True, "monitores_inear": True, "mesa_digital": True},
    {"aftermovie": True, "sesion_fotos": True, "material_promocional": True}
]

# Géneros musicales
generos_musicales = [
    "POP", "ROCK", "ELECTRONICA", "LATINO", "JAZZ", "CLASICA",
    "FOLK", "REGGAE", "BLUES", "HIP_HOP", "R&B", "SOUL",
    "FUNK", "DISCO", "INDIE", "METAL", "PUNK", "COUNTRY",
    "REGGAETON", "TRAP", "FLAMENCO", "SALSA", "BACHATA", "TANGO"
]

# Condiciones para el raider
condiciones_raider = [
    "Acceso a electricidad trifásica",
    "Zona cubierta para equipos",
    "Parking reservado para carga/descarga",
    "Agua potable disponible para músicos",
    "Zona de descanso para el equipo",
    "Catering básico para músicos en eventos largos",
    "Asistencia para montaje y desmontaje",
    "Protección contra lluvia en exteriores",
    "Seguridad para equipos durante pausas",
    "Iluminación básica en el escenario",
    "Acceso anticipado para pruebas de sonido",
    "Camerino o espacio privado para cambios",
    "Coordinación con responsable del local",
    "Espacio mínimo garantizado para equipos",
    "Suelo regular y estable para montaje"
]

# Tipos de música
tipos_musica = ["DJ", "BANDA", "SOLISTA", "ORQUESTA", "DUO", "TRIO", "CUARTETO"]

# Funciones auxiliares de ejemplo anterior
ciudades_provincias = [
    {"ciudad": "Barcelona", "provincia": "Barcelona", "codigo_postal": "08001"},
    {"ciudad": "Madrid", "provincia": "Madrid", "codigo_postal": "28001"},
    {"ciudad": "Valencia", "provincia": "Valencia", "codigo_postal": "46001"},
    {"ciudad": "Sevilla", "provincia": "Sevilla", "codigo_postal": "41001"},
    {"ciudad": "Zaragoza", "provincia": "Zaragoza", "codigo_postal": "50001"},
    {"ciudad": "Málaga", "provincia": "Málaga", "codigo_postal": "29001"},
    {"ciudad": "Bilbao", "provincia": "Vizcaya", "codigo_postal": "48001"},
    {"ciudad": "Alicante", "provincia": "Alicante", "codigo_postal": "03001"},
    {"ciudad": "Córdoba", "provincia": "Córdoba", "codigo_postal": "14001"},
    {"ciudad": "Valladolid", "provincia": "Valladolid", "codigo_postal": "47001"},
    {"ciudad": "Vigo", "provincia": "Pontevedra", "codigo_postal": "36201"},
    {"ciudad": "Gijón", "provincia": "Asturias", "codigo_postal": "33201"},
    {"ciudad": "Palma", "provincia": "Islas Baleares", "codigo_postal": "07001"},
    {"ciudad": "Las Palmas", "provincia": "Las Palmas", "codigo_postal": "35001"},
    {"ciudad": "Murcia", "provincia": "Murcia", "codigo_postal": "30001"}
]

calles = [
    "Calle Mayor", "Avenida Diagonal", "Plaza Catalunya", "Paseo de Gracia",
    "Calle Serrano", "Gran Vía", "Calle Alcalá", "Paseo del Prado",
    "Calle Colón", "Avenida del Puerto", "Plaza del Ayuntamiento", "Calle Ruzafa",
    "Avenida de la Constitución", "Calle Sierpes", "Plaza Nueva", "Calle Tetuán",
    "Paseo Independencia", "Plaza del Pilar", "Calle Alfonso", "Calle Don Jaime",
    "Calle Larios", "Plaza de la Merced", "Paseo del Parque", "Calle Granada",
    "Gran Vía de Don Diego López de Haro", "Plaza Circular", "Calle Ercilla", "Alameda Recalde"
]

disponibilidades = [
    ["L-V", "9:00-18:00"],
    ["L-S", "10:00-20:00"],
    ["L-D", "9:00-21:00"],
    ["L-V", "8:00-17:00"],
    ["L-S", "9:00-19:00"],
    ["M-S", "10:00-19:00"],
    ["X-D", "9:00-20:00"],
    ["J-D", "11:00-22:00"],
    ["V-D", "10:00-22:00"],
    ["V-D", "18:00-3:00"]
]

nombres_personas = [
    "Carlos Martínez", "Laura Sánchez", "Miguel Torres", "Ana Rodríguez",
    "David Fernández", "María López", "Pablo García", "Elena González",
    "Javier Ruiz", "Sofía Moreno", "Jorge Navarro", "Lucía Jiménez",
    "Daniel Ortega", "Carmen Serrano", "Alberto Medina", "Isabel Flores",
    "Roberto Castro", "Cristina Díaz", "Francisco Herrera", "Patricia Muñoz"
]

roles_musica = [
    "DJ principal", "Técnico de sonido", "Vocalista", "Guitarrista", 
    "Bajista", "Baterista", "Saxofonista", "Pianista", "Violinista",
    "Técnico de luces", "Director", "Productor", "Percusionista",
    "Ingeniero de sonido", "Teclista", "Arreglista", "Animador"
]

# Generar UUIDs consistentes basados en índice
def generar_uuid(indice: int, offset: int = 0) -> str:
    # Crear UUID predecible basado en índice
    base_uuid = f"c{indice+offset:04d}0000-0000-4000-c000-00000000{indice+offset:04d}"
    return base_uuid

# Función para generar ejemplos de servicios de música
def generar_servicios_musica(cantidad: int) -> List[Dict[str, Any]]:
    servicios = []
    
    for i in range(cantidad):
        # Generar UUIDs para cada entidad relacionada
        servicio_id = generar_uuid(i, 1000)
        account_id = generar_uuid(i, 2000)
        musica_id = generar_uuid(i, 3000)
        raider_id = generar_uuid(i, 4000)
        
        # Seleccionar ciudad y provincia
        ciudad_provincia = random.choice(ciudades_provincias)
        
        # Determinar tipo de música y número de integrantes
        musica_type = random.choice(tipos_musica)
        if musica_type == "SOLISTA":
            num_integrantes = 1
        elif musica_type == "DUO":
            num_integrantes = 2
        elif musica_type == "TRIO":
            num_integrantes = 3
        elif musica_type == "CUARTETO":
            num_integrantes = 4
        elif musica_type == "DJ":
            num_integrantes = random.randint(1, 3)
        elif musica_type == "BANDA":
            num_integrantes = random.randint(3, 8)
        else:  # ORQUESTA
            num_integrantes = random.randint(8, 15)
        
        # Generar equipo de música
        equipo = []
        for j in range(num_integrantes):
            equipo.append({
                "nombre": random.choice(nombres_personas),
                "rol": random.choice(roles_musica)
            })
        
        # Generar servicio completo
        servicio = {
            "id": servicio_id,
            "type": "MUSICA",
            "name": random.choice(nombres_musica),
            "price": round(random.uniform(500, 3000), 2),
            "images": [
                f"https://ejemplo.com/musica{i}_1.jpg",
                f"https://ejemplo.com/musica{i}_2.jpg",
                f"https://ejemplo.com/musica{i}_3.jpg"
            ],
            "description": random.choice(descripciones_musica),
            "availability": random.choice([True, True, True, False]),  # Mayor probabilidad de disponible
            "availability_rule": random.choice(disponibilidades),
            "services_extra": servicios_extra_musica[i % len(servicios_extra_musica)],
            "account_id": account_id,
            "address": {
                "direccion": f"{random.choice(calles)} {random.randint(1, 150)}",
                "ciudad": ciudad_provincia["ciudad"],
                "codigo_postal": ciudad_provincia["codigo_postal"],
                "provincia": ciudad_provincia["provincia"]
            },
            "musica": {
                "id": musica_id,
                "musica_type": musica_type,
                "duracion": round(random.uniform(2, 8), 1),
                "generos": random.sample(generos_musicales, k=random.randint(3, 6)),
                "caracteristicas": random.sample(caracteristicas_musica, k=random.randint(3, 5)),
                "raider_id": raider_id,
                "raider": {
                    "id": raider_id,
                    "num_integrantes": num_integrantes,
                    "equipo": equipo,
                    "solicitar_cancion_nueva": random.choice([True, False]),
                    "coste_cancion_nueva": round(random.uniform(0, 50), 2) if random.choice([True, False]) else 0.0,
                    "equipo_propio": random.choice([True, True, False]),  # Mayor probabilidad de tener equipo propio
                    "coste_equipo_propio": round(random.uniform(0, 500), 2) if random.choice([True, True, False]) else 0.0,
                    "disponible_sin_equipo": random.choice([True, False]),
                    "dimensiones_escenario": {
                        "ancho": round(random.uniform(2, 8), 1),
                        "largo": round(random.uniform(2, 10), 1),
                        "alto": round(random.uniform(0.3, 1), 1)
                    },
                    "condiciones": random.sample(condiciones_raider, k=random.randint(2, 5))
                }
            }
        }
        
        servicios.append(servicio)
    
    return servicios

# Generar los ejemplos
ejemplos_musica = generar_servicios_musica(30)

# Guardar en un archivo JSON con formato legible
with open('ejemplos/musica.json', 'w', encoding='utf-8') as f:
    json.dump(ejemplos_musica, f, ensure_ascii=False, indent=2)

print(f"Se generaron {len(ejemplos_musica)} ejemplos de servicios de música")

# Para mostrar un ejemplo
print("\nEjemplo de servicio de música:")
print(json.dumps(ejemplos_musica[0], ensure_ascii=False, indent=2)) 