import json
import uuid
import random
from datetime import datetime, timedelta
import sys
import os

# Añadir la ruta para poder importar el archivo con los servicios originales
sys.path.append(os.path.join(os.path.dirname(__file__), ".."))

# Función para generar un UUID v4 aleatorio
def generar_uuid():
    return str(uuid.uuid4())

# Función para convertir servicios al nuevo formato
def convertir_servicios(servicios):
    todos_servicios = []
    
    # Mapeo de categorías a tipos de servicio según el formato de destino
    mapeo_tipos = {
        "Espai": "ESPAI",
        "Catering": "CATERING",
        "Mobiliari": "MOBILIARI",
        "Decoració": "DECORACION",
        "Musica": "MUSICA",
        "Fotografia": "FOTOGRAFIA"
    }
    
    # Ciudades y provincias para dirección aleatoria
    ciudades_provincias = [
        {"ciudad": "Barcelona", "provincia": "Barcelona", "codigo_postal": "08001"},
        {"ciudad": "Madrid", "provincia": "Madrid", "codigo_postal": "28001"},
        {"ciudad": "Valencia", "provincia": "Valencia", "codigo_postal": "46001"},
        {"ciudad": "Sevilla", "provincia": "Sevilla", "codigo_postal": "41001"},
        {"ciudad": "Málaga", "provincia": "Málaga", "codigo_postal": "29001"},
        {"ciudad": "Bilbao", "provincia": "Vizcaya", "codigo_postal": "48001"}
    ]
    
    calles = [
        "Calle Mayor", "Avenida Diagonal", "Plaza Catalunya", "Paseo de Gracia",
        "Calle Serrano", "Gran Vía", "Calle Alcalá", "Paseo del Prado"
    ]
    
    # Patrones de disponibilidad
    disponibilidades = [
        ["L-V", "9:00-18:00"],
        ["L-S", "10:00-20:00"],
        ["L-D", "9:00-21:00"],
        ["X-D", "9:00-20:00"],
        ["V-D", "10:00-22:00"]
    ]
    
    # Para cada categoría y servicios
    for categoria, servicios_categoria in servicios.items():
        for nombre_servicio, detalles in servicios_categoria.items():
            # Generar un tipo de servicios extra según la categoría
            services_extra = {}
            if categoria == "Espai":
                services_extra = {
                    "parking": random.choice([True, False]),
                    "wifi": random.choice([True, False]),
                    "accesibilidad": random.choice([True, False])
                }
            elif categoria == "Catering":
                services_extra = {
                    "menu_degustacion": random.choice([True, False]),
                    "opciones_vegetarianas": random.choice([True, False]),
                    "barra_libre": random.choice([True, False])
                }
            elif categoria == "Musica":
                services_extra = {
                    "equipo_sonido": random.choice([True, False]),
                    "iluminacion": random.choice([True, False]),
                    "solicitud_canciones": random.choice([True, False])
                }
            elif categoria == "Fotografia":
                services_extra = {
                    "album_digital": random.choice([True, False]),
                    "video_resumen": random.choice([True, False]),
                    "photocall": random.choice([True, False])
                }
            elif categoria == "Mobiliari":
                services_extra = {
                    "montaje": random.choice([True, False]),
                    "desmontaje": random.choice([True, False]),
                    "traslado": random.choice([True, False])
                }
            elif categoria == "Decoració":
                services_extra = {
                    "flores_frescas": random.choice([True, False]),
                    "personalizacion": random.choice([True, False]),
                    "iluminacion_decorativa": random.choice([True, False])
                }
            
            # Dirección aleatoria
            dir_info = random.choice(ciudades_provincias)
            direccion = {
                "direccion": f"{random.choice(calles)} {random.randint(1, 150)}",
                "ciudad": dir_info["ciudad"],
                "codigo_postal": dir_info["codigo_postal"],
                "provincia": dir_info["provincia"]
            }
            
            # Crear estructura base del servicio
            servicio = {
                "id": generar_uuid(),
                "type": mapeo_tipos[categoria],
                "name": nombre_servicio,
                "price": float(detalles.get("price", 0)) if "price" in detalles else float(detalles.get("price_per_person", 0)),
                "images": [
                    f"https://ejemplo.com/{categoria.lower()}_{random.randint(1, 100)}_1.jpg",
                    f"https://ejemplo.com/{categoria.lower()}_{random.randint(1, 100)}_2.jpg",
                    f"https://ejemplo.com/{categoria.lower()}_{random.randint(1, 100)}_3.jpg"
                ],
                "description": detalles.get("description", ""),
                "availability": True,
                "availability_rule": random.choice(disponibilidades),
                "services_extra": services_extra,
                "account_id": generar_uuid(),
                "address": direccion
            }
            
            # Añadir información específica según la categoría
            if categoria == "Espai":
                caracteristicas = detalles.get("caracteristicas", [])
                servicio["espai"] = {
                    "id": generar_uuid(),
                    "espai_type": detalles.get("espai_type", ""),
                    "capacidad_minima": detalles.get("capacitat_min", 0),
                    "capacidad_maxima": detalles.get("capacitat_max", 0),
                    "caracteristicas": caracteristicas
                }
            
            elif categoria == "Catering":
                servicio["catering"] = {
                    "id": generar_uuid(),
                    "catering_type": detalles.get("catering_type", ""),
                    "precio_persona": detalles.get("price_per_person", 0),
                    "minimo_comensales": detalles.get("min_guests", 0),
                    "maximo_comensales": detalles.get("max_guests", 0),
                    "menu_opciones": detalles.get("menu_options", [])
                }
            
            elif categoria == "Mobiliari":
                servicio["mobiliari"] = {
                    "id": generar_uuid(),
                    "mobiliari_type": detalles.get("mobiliari_type", ""),
                    "materiales": detalles.get("materials", []),
                    "colores": detalles.get("colors", [])
                }
            
            elif categoria == "Decoració":
                servicio["decoracion"] = {
                    "id": generar_uuid(),
                    "decoracion_type": detalles.get("decoracio_type", ""),
                    "temas": detalles.get("themes", []),
                    "instalacion_incluida": random.choice([True, False])
                }
            
            elif categoria == "Musica":
                equipo = []
                num_integrantes = random.randint(1, 5)
                
                for i in range(num_integrantes):
                    equipo.append({
                        "nombre": f"Músico {i+1}",
                        "rol": random.choice(["Vocalista", "Guitarra", "Bajo", "Batería", "Teclado", "DJ"])
                    })
                
                servicio["musica"] = {
                    "id": generar_uuid(),
                    "musica_type": detalles.get("musica_type", ""),
                    "generos": detalles.get("genres", []),
                    "duracion": round(random.uniform(2.0, 5.0), 1),
                    "raider_id": generar_uuid(),
                    "raider": {
                        "id": generar_uuid(),
                        "num_integrantes": num_integrantes,
                        "equipo": equipo,
                        "equipo_propio": True,
                        "coste_equipo_propio": round(random.uniform(100, 300), 2),
                        "condiciones": ["Acceso a electricidad", "Espacio techado"]
                    }
                }
            
            elif categoria == "Fotografia":
                equipo = []
                num_integrantes = random.randint(1, 3)
                
                for i in range(num_integrantes):
                    equipo.append({
                        "nombre": f"Fotógrafo {i+1}",
                        "rol": random.choice(["Fotógrafo principal", "Asistente", "Videógrafo", "Editor"])
                    })
                
                servicio["fotografia"] = {
                    "id": generar_uuid(),
                    "fotografia_type": detalles.get("fotografia_type", ""),
                    "servicio_especial_type": None,
                    "duracion": round(random.uniform(2.0, 8.0), 1),
                    "caracteristicas": detalles.get("specialties", []),
                    "raider_id": generar_uuid(),
                    "raider": {
                        "id": generar_uuid(),
                        "num_integrantes": num_integrantes,
                        "equipo": equipo,
                        "equipo_propio": True,
                        "coste_equipo_propio": round(random.uniform(50, 200), 2),
                        "disponible_sin_equipo": False,
                        "condiciones": ["Iluminación básica", "Acceso a electricidad"]
                    }
                }
            
            todos_servicios.append(servicio)
    
    return todos_servicios

try:
    # Importar los servicios desde el archivo de VectorService
    from PRUEBAS.Assitent.vector_service import VectorService
    
    # Crear una instancia del servicio
    vector_service = VectorService()
    
    # Obtener los servicios
    services = vector_service.services
    
    print(f"Se han cargado {sum(len(cat) for cat in services.values())} servicios del archivo vector_service.py")
    
    # Convertir los servicios al nuevo formato
    servicios_convertidos = convertir_servicios(services)
    
    # Guardar en un archivo JSON
    with open('ejemplos/servicios_convertidos.json', 'w', encoding='utf-8') as f:
        json.dump(servicios_convertidos, f, ensure_ascii=False, indent=2)
    
    print(f"Se han convertido {len(servicios_convertidos)} servicios al nuevo formato en 'PRUEBAS/ejemplos/servicios_convertidos.json'")

except Exception as e:
    print(f"Error al cargar los servicios: {str(e)}")
    
    # Usar un conjunto de datos de prueba si falla la importación
    print("Usando datos de prueba...")
    services = {
        "Espai": {
            "Masia del Sola": {"espai_type": "Masia", "capacitat_min": 6, "capacitat_max": 100, "price": 100, "description": "Masia con jardín, parking y producto casolano", "caracteristicas": ["jardín", "parking", "producto de calidad", "interior", "exterior"]},
            "Urbisol": {"espai_type": "Masia", "capacitat_min": 10, "capacitat_max": 150, "price": 130, "description": "Masía moderna con piscina y área de eventos", "caracteristicas": ["piscina", "moderno", "zona eventos"]},
            "La Torre Roja": {"espai_type": "Castillo", "capacitat_min": 20, "capacitat_max": 300, "price": 500, "description": "Castillo medieval ideal para bodas temáticas", "caracteristicas": ["histórico", "temático", "vistas panorámicas"]}
        },
        "Catering": {
            "Delicious Catering": {"catering_type": "Buffet", "price_per_person": 50, "min_guests": 20, "max_guests": 200, "menu_options": ["Internacional", "Vegetariana", "Vegana"], "description": "Buffet de alta calidad con opciones internacionales, vegetarianas y veganas."},
            "Gourmet Events": {"catering_type": "Servicio en mesa", "price_per_person": 70, "min_guests": 30, "max_guests": 150, "menu_options": ["Gourmet", "Mariscos"], "description": "Servicio de catering gourmet especializado en mariscos y platos de alta cocina."}
        },
        "Musica": {
            "DJ Destor": {"musica_type": "DJ", "genres": ["Electrónica", "House", "Techno"], "price": 400, "description": "DJ con experiencia internacional y mezclas en vivo."},
            "Jazz Quartet Barcelona": {"musica_type": "Grupo", "genres": ["Jazz", "Swing"], "price": 700, "description": "Cuarteto profesional especializado en jazz ambiental."}
        }
    }
    
    # Convertir los servicios al nuevo formato
    servicios_convertidos = convertir_servicios(services)
    
    # Guardar en un archivo JSON
    with open('PRUEBAS/ejemplos/servicios_convertidos.json', 'w', encoding='utf-8') as f:
        json.dump(servicios_convertidos, f, ensure_ascii=False, indent=2)
    
    print(f"Se han convertido {len(servicios_convertidos)} servicios al nuevo formato en 'PRUEBAS/ejemplos/servicios_convertidos.json'") 