import json
import os

# Lista de archivos JSON a combinar
archivos_json = [
    'ejemplos/fotografias.json',
    'ejemplos/catering.json',
    'ejemplos/musica.json',
    'ejemplos/espai.json',
    'ejemplos/mobiliari.json',
    'ejemplos/decoracion.json'
]

# Función para verificar si un archivo existe
def archivo_existe(ruta):
    return os.path.isfile(ruta)

# Lista para almacenar todos los servicios
todos_servicios = []

# Procesar cada archivo JSON
for archivo in archivos_json:
    if archivo_existe(archivo):
        try:
            with open(archivo, 'r', encoding='utf-8') as f:
                servicios = json.load(f)
                print(f"Importados {len(servicios)} servicios de {archivo}")
                todos_servicios.extend(servicios)
        except Exception as e:
            print(f"Error al procesar {archivo}: {str(e)}")
    else:
        print(f"El archivo {archivo} no existe.")

# Guardar todos los servicios en un único archivo JSON
if todos_servicios:
    with open('ejemplos/todos_servicios.json', 'w', encoding='utf-8') as f:
        json.dump(todos_servicios, f, ensure_ascii=False, indent=2)
    
    print(f"Se combinaron un total de {len(todos_servicios)} servicios en todos_servicios.json")
else:
    print("No se pudo combinar ningún servicio debido a errores o archivos inexistentes.")

# Mostrar desglose por tipo de servicio
tipos_servicio = {}
for servicio in todos_servicios:
    tipo = servicio.get('type', 'DESCONOCIDO')
    tipos_servicio[tipo] = tipos_servicio.get(tipo, 0) + 1

print("\nDesglose por tipo de servicio:")
for tipo, cantidad in tipos_servicio.items():
    print(f"{tipo}: {cantidad} servicios") 