# EventAI

EventAI es una plataforma web inteligente para la gestión y organización de eventos, que conecta a clientes y proveedores, permitiendo crear, personalizar y gestionar eventos de forma sencilla y eficiente gracias al uso de inteligencia artificial.

## ¿De qué va la página web?

EventAI permite a los usuarios:

- **Clientes:**  
  - Buscar y contratar servicios (espacios, catering, música, fotografía, etc.).
  - Crear y gestionar sus propios eventos.
  - Usar un asistente inteligente para generar eventos personalizados.
  - Contactar con soporte y consultar preguntas frecuentes.
  - Gestionar sus espacios propios.
  - Acceder a un panel moderno y personalizado.

- **Proveedores:**  
  - Todas las funcionalidades de cliente.
  - Publicar y gestionar sus servicios.
  - Gestionar eventos y espacios propios desde un panel especializado para proveedores.

La plataforma cuenta con autenticación, roles diferenciados (cliente/proveedor), buscador de usuarios, sistema de mensajería, pagos y un diseño moderno y responsive.

---

## Instalación y dependencias

### 1.1. Backend

#### 1.1.1. Instalación de las dependencias del backend

Se utiliza **Poetry** como gestor de dependencias y entorno virtual para el backend. Toda la configuración y dependencias están en el archivo `pyproject.toml`.

**Instalación de Poetry:**

- **Linux, macOS, Windows (WSL):**
  ```bash
  curl -sSL https://install.python-poetry.org | python3 -
  ```
- **Windows (PowerShell):**
  ```powershell
  curl -sSL (Invoke-WebRequest -Uri https://install.python-poetry.org -UseBasicParsing).Content | py -
  ```
- Verifica la instalación:
  ```bash
  poetry --version
  # Poetry (version 1.8.2)
  ```

**Instalación de dependencias:**
```bash
cd backend
poetry install
```
- Para actualizar dependencias:
  ```bash
  poetry update
  ```
- Información del entorno virtual:
  ```bash
  poetry env info
  ```
- Abrir un intérprete de Python dentro del entorno:
  ```bash
  poetry shell
  ```
- Ejecutar comandos dentro del entorno:
  ```bash
  poetry run <comando>
  ```

> Muchos IDEs como PyCharm o VSCode permiten integración directa con Poetry.

#### 1.1.2. Configuración del backend

La configuración se realiza mediante un archivo `.env` en la raíz del backend (no debe subirse a GitHub). Ejemplo:

```
# Configuracion backend
PROJECT_NAME=XXX
FIRST_SUPERUSER=XXXX
FIRST_SUPERUSER_PASSWORD=XXXX
BACKEND_CORS_ORIGINS=http://localhost:8080/

# Configuracion AWS
AWS_REGION=XXXX
BEDROCK_MODEL_ID=anthropic.claude-v2:1
AWS_S3_BUCKET=XXXX
AWS_ACCESS_KEY_ID=XXXXXX
AWS_SECRET_ACCESS_KEY=XXXXXX

# Configuración de Email
SMTP_TLS=True
SMTP_PORT=587
SMTP_HOST=smtp.gmail.com
SMTP_USER=XXXXX
SMTP_PASSWORD=XXXXX
EMAILS_FROM_EMAIL=XXXXX
EMAILS_FROM_NAME=XXXXX
```

#### 1.1.3. Creación de la base de datos

Se utiliza **SQLite** para desarrollo. Los modelos están definidos en `app.models` y las migraciones se gestionan con **Alembic**.

- Para aplicar la migración inicial:
  ```bash
  alembic upgrade head
  ```

#### 1.1.4. Levantar el backend

- Para arrancar el backend:
  ```bash
  poetry run uvicorn app.main:app
  ```
- Para desarrollo (con recarga automática):
  ```bash
  poetry run uvicorn app.main:app --reload
  ```
- Cambiar puerto o exponer a otras máquinas:
  ```bash
  poetry run uvicorn app.main:app --reload --port 8000 --host 0.0.0.0
  ```

#### 1.1.5. Acceso a la documentación de la API

Una vez levantado el backend, accede a la documentación interactiva en:  
[http://127.0.0.1:8000/docs](http://127.0.0.1:8000/docs)

---

### 1.2. Frontend

El frontend utiliza **Vue.js** para construir la interfaz de usuario.

#### 1.2.1 Instalación de npm y Node.js

- Instala Node.js y npm desde la [página oficial](https://nodejs.org/) o usando tu gestor de paquetes:
  ```bash
  sudo apt install nodejs
  sudo apt install npm
  ```
- Verifica la instalación:
  ```bash
  node --version
  npm --version
  ```
- (Opcional) Instala NVM para gestionar versiones de Node.js: [Guía NVM](https://phoenixnap.com/kb/install-latest-node-js-and-nmp-on-ubuntu)

#### 1.2.2 Instalación de Vue CLI

```bash
npm install -g @vue/cli
npm install -g @vue/cli-init
vue --version
```

#### 1.2.3 Crear y configurar el proyecto

- Para crear el proyecto:
  ```bash
  vue init webpack frontend
  ```
- La estructura principal es:
  - `App.vue`: componente raíz
  - `assets/`: imágenes y recursos
  - `components/`: todos los componentes Vue
  - `main.js`: inicializa la app
  - `router/index.js`: rutas
  - `config/`: configuración por entorno

#### 1.2.4. Ejecutar el frontend

```bash
cd frontend
npm run dev
```

---

## Estructura del proyecto

```
TFG/
│
├── backend/
│   ├── app/
│   │   ├── models/
│   │   ├── crud/
│   │   ├── services/
│   │   ├── api/
│   │   │   ├── routes/
│   │   │   └── ...
│   │   ├── main.py
│   │   └── ...
│   ├── alembic/
│   ├── pyproject.toml
│   └── ...
│
├── frontend/
│   ├── src/
│   │   ├── assets/
│   │   ├── components/
│   │   │   ├── mainPageVendor.vue
│   │   │   ├── mainPageClient.vue
│   │   │   ├── Contacto.vue
│   │   │   ├── AyudaFAQ.vue
│   │   │   ├── myProfile.vue
│   │   │   ├── event_services/
│   │   │   └── ...
│   │   ├── router/
│   │   │   └── index.js
│   │   ├── services/
│   │   ├── App.vue
│   │   └── main.js
│   ├── public/
│   └── package.json
│
├── README.md
└── ...
```

---

## Cómo ejecutar el proyecto

### Backend
```bash
cd backend
poetry run uvicorn app.main:app --reload
```

### Frontend
```bash
cd frontend
npm run dev
```

---

## Funcionalidades destacadas

- Registro y login con roles (cliente/proveedor)
- Paneles diferenciados para cada tipo de usuario
- Buscador de usuarios en tiempo real
- Gestión de servicios, eventos y espacios propios
- Asistente inteligente para generación de eventos
- Página de contacto y FAQ
- Sistema de pagos
- Diseño responsive y moderno

---

## Contacto

Para cualquier duda o sugerencia, puedes usar la página de contacto de la plataforma o escribir a:  
**info@eventai.com**
