"""add Events, espai propi, arreglar services and addition costs

Revision ID: 134485f44991
Revises: 769993fe8290
Create Date: 2025-05-19 18:22:20.499003

"""
from alembic import op
import sqlalchemy as sa
import sqlmodel.sql.sqltypes


# revision identifiers, used by Alembic.
revision = '134485f44991'
down_revision = '769993fe8290'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    conn = op.get_bind()
    inspector = sa.inspect(conn)
    existing_tables = inspector.get_table_names()
    existing_columns = {table: [col['name'] for col in inspector.get_columns(table)] for table in existing_tables}
    
    if 'espai_propi' not in existing_tables:
        op.create_table('espai_propi',
        sa.Column('nombre', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column('tipus', sa.Enum('SALA_PRIVADA', 'TERRAZA', 'SALON', 'CASA_PARTICULAR', 'JARDIN_PRIVADO', 'AZOTEA', 'PISO', 'CASA_RURAL', 'NAVE_INDUSTRIAL', 'PARCELA', 'LOCAL_PROPIO', 'MASIA', 'OTRO', name='tipusespaipropi'), nullable=False),
        sa.Column('address', sa.JSON(), nullable=True),
        sa.Column('descripcion', sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column('capacitat_aproximada', sa.Integer(), nullable=True),
        sa.Column('caracteristicas', sa.JSON(), nullable=True),
        sa.Column('id', sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.Column('account_id', sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.ForeignKeyConstraint(['account_id'], ['account.id'], ),
        sa.PrimaryKeyConstraint('id')
        )
    if 'eventservice' not in existing_tables:
        op.create_table('eventservice',
        sa.Column('id', sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.Column('event_id', sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.Column('service_id', sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.ForeignKeyConstraint(['event_id'], ['event.id'], ),
        sa.ForeignKeyConstraint(['service_id'], ['service.id'], ),
        sa.PrimaryKeyConstraint('id')
        )
    
    # Verificar si las columnas existen antes de añadirlas
    if 'event' in existing_tables:
        if 'estat' not in existing_columns['event']:
            op.add_column('event', sa.Column('estat', sa.Enum('EN_CURSO', 'GUARDADO', 'PAGADO', 'EXPIRADO', 'CANCELADO', 'FINALIZADO', name='estadoevent'), nullable=False))
        if 'espai_propi_id' not in existing_columns['event']:
            with op.batch_alter_table('event') as batch_op:
                batch_op.add_column(sa.Column('espai_propi_id', sqlmodel.sql.sqltypes.GUID(), nullable=True))
                batch_op.create_foreign_key(
                    'fk_event_espai_propi_id_espai_propi',
                    'espai_propi',
                    ['espai_propi_id'],
                    ['id']
                )

    # Añadir columna dimensions a mobiliaridecoracio si no existe
    if 'mobiliaridecoracio' in existing_tables and 'dimensions' not in existing_columns['mobiliaridecoracio']:
        op.add_column('mobiliaridecoracio', sa.Column('dimensions', sa.JSON(), nullable=True))

    # Eliminar columnas de raider si existen
    if 'raider' in existing_tables:
        if 'disponible_sin_equipo' in existing_columns['raider']:
            op.drop_column('raider', 'disponible_sin_equipo')
        if 'coste_cancion_nueva' in existing_columns['raider']:
            op.drop_column('raider', 'coste_cancion_nueva')
        if 'coste_equipo_propio' in existing_columns['raider']:
            op.drop_column('raider', 'coste_equipo_propio')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('raider', sa.Column('coste_equipo_propio', sa.FLOAT(), nullable=True))
    op.add_column('raider', sa.Column('coste_cancion_nueva', sa.FLOAT(), nullable=True))
    op.add_column('raider', sa.Column('disponible_sin_equipo', sa.BOOLEAN(), nullable=True))
    op.drop_column('mobiliaridecoracio', 'dimensions')
    with op.batch_alter_table('event') as batch_op:
        batch_op.drop_constraint('fk_event_espai_propi_id_espai_propi', type_='foreignkey')
        batch_op.drop_column('espai_propi_id')
        batch_op.drop_column('estat')
    op.drop_table('eventservice')
    op.drop_table('espai_propi')
    # ### end Alembic commands ###
