"""add availability, add new and update event-service 

Revision ID: 2cc823242981
Revises: 134485f44991
Create Date: 2025-05-21 00:46:50.966331

"""
from alembic import op
import sqlalchemy as sa
import sqlmodel.sql.sqltypes
from sqlalchemy.dialects import sqlite

# revision identifiers, used by Alembic.
revision = '2cc823242981'
down_revision = '134485f44991'
branch_labels = None
depends_on = None


def upgrade():
    conn = op.get_bind()
    inspector = sa.inspect(conn)
    existing_tables = inspector.get_table_names()
    existing_columns = {table: [col['name'] for col in inspector.get_columns(table)] for table in existing_tables}
    # ### commands auto generated by Alembic - please adjust! ###
    if 'availabilityrule' not in existing_tables:
        op.create_table('availabilityrule',
        sa.Column('service_id', sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.Column('dias_semana', sa.JSON(), nullable=True),
        sa.Column('hora_inicio', sa.Time(), nullable=False),
        sa.Column('hora_fin', sa.Time(), nullable=False),
        sa.Column('price', sa.Float(), nullable=False),
        sa.Column('min_days_before', sa.Integer(), nullable=False),
        sa.Column('id', sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.ForeignKeyConstraint(['service_id'], ['service.id'], ),
        sa.PrimaryKeyConstraint('id')
        )
    print(existing_columns['eventservice'])
    if 'cantidad' not in existing_columns['eventservice']:
        op.add_column('eventservice', sa.Column('cantidad', sa.Integer(), nullable=True))
    if 'data_inicio' not in existing_columns['eventservice']:
        op.add_column('eventservice', sa.Column('data_inicio', sa.DateTime(), nullable=True))
    if 'data_fin' not in existing_columns['eventservice']:
        op.add_column('eventservice', sa.Column('data_fin', sa.DateTime(), nullable=True))
    
    if 'service_include' not in existing_columns['service']:
        op.add_column('service', sa.Column('service_include', sa.JSON(), nullable=True))
        op.execute("UPDATE service SET service_include = services_extra WHERE services_extra IS NOT NULL")
    
    if 'services_extra' in existing_columns['service']:
        op.drop_column('service', 'services_extra')
    if 'price' in existing_columns['service']:
        op.drop_column('service', 'price')
    if 'availability' in existing_columns['service']:
        op.drop_column('service', 'availability')
    if 'availability_rule' in existing_columns['service']:
        op.drop_column('service', 'availability_rule')
    if 'temp_id' in existing_columns['user']:
        op.drop_column('user', 'temp_id')

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('user', sa.Column('temp_id', sa.CHAR(length=32), nullable=True))
    
    op.add_column('service', sa.Column('availability_rule', sqlite.JSON(), nullable=True))
    op.add_column('service', sa.Column('availability', sa.BOOLEAN(), nullable=True))
    op.add_column('service', sa.Column('price', sa.FLOAT(), nullable=True))
    op.add_column('service', sa.Column('services_extra', sqlite.JSON(), nullable=True))
    
    op.execute("UPDATE service SET services_extra = service_include WHERE service_include IS NOT NULL")
   
    op.drop_column('service', 'service_include')
    op.drop_column('eventservice', 'data_fin')
    op.drop_column('eventservice', 'data_inicio')
    op.drop_column('eventservice', 'cantidad')
    op.drop_table('availabilityrule')
    # ### end Alembic commands ###
