"""Added Account and update user

Revision ID: 506c9e9d0df8
Revises: e2412789c190
Create Date: 2025-04-19 12:19:29.106680

"""
from alembic import op
import sqlalchemy as sa
import sqlmodel.sql.sqltypes


# revision identifiers, used by Alembic.
revision = '506c9e9d0df8'
down_revision = 'e2412789c190'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    # Primero modificamos la tabla user para cambiar el tipo de ID
    with op.batch_alter_table("user", schema=None) as batch_op:
        # SQLite no permite cambiar el tipo directamente, así que creamos una columna temporal
        batch_op.add_column(sa.Column('temp_id', sqlmodel.sql.sqltypes.GUID(), nullable=True))
        # La columna id original se mantiene como INTEGER

    # Luego creamos la tabla account con GUID como ID
    op.create_table('account',
        sa.Column('id', sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.Column('photo', sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column('bio', sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column('username', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.ForeignKeyConstraint(['id'], ['user.id'], ),
        sa.PrimaryKeyConstraint('id')
    )
    
    # Añadimos las columnas restantes a la tabla user
    op.add_column('user', sa.Column('role', sa.Enum('CLIENT_PARTICULAR', 'CLIENT_BUSINESS', 'VENDOR_BUSINESS', 'VENDOR_PARTICULAR', name='roleenum'), nullable=True, server_default='CLIENT_PARTICULAR'))
    op.add_column('user', sa.Column('cif', sqlmodel.sql.sqltypes.AutoString(), nullable=True))
    op.add_column('user', sa.Column('dni', sqlmodel.sql.sqltypes.AutoString(), nullable=True))
    
    # Creamos los índices necesarios
    op.create_index(op.f('ix_user_cif'), 'user', ['cif'], unique=True)
    op.create_index(op.f('ix_user_dni'), 'user', ['dni'], unique=True)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_user_dni'), table_name='user')
    op.drop_index(op.f('ix_user_cif'), table_name='user')
    
    op.drop_column('user', 'dni')
    op.drop_column('user', 'cif')
    op.drop_column('user', 'role')
    op.drop_column('user', 'temp_id')  # Eliminamos la columna temporal
    
    op.drop_table('account')
    # ### end Alembic commands ###
