"""Añadir todos eventos y todos los tipos de servicio y elementos necessarios

Revision ID: 769993fe8290
Revises: 506c9e9d0df8
Create Date: 2025-05-06 19:24:53.187632

"""
from alembic import op
import sqlalchemy as sa
import sqlmodel.sql.sqltypes


# revision identifiers, used by Alembic.
revision = '769993fe8290'
down_revision = '506c9e9d0df8'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    # Verificar si las tablas existen antes de crearlas
    conn = op.get_bind()
    inspector = sa.inspect(conn)
    existing_tables = inspector.get_table_names()

    if 'event' not in existing_tables:
        op.create_table('event',
        sa.Column('name', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column('tipus', sa.Enum('BODA', 'GRADUACIO', 'FESTA', 'CELEBRACIO', 'MENJAR_GRUP', 'ALTRES', name='tipusevent'), nullable=False),
        sa.Column('pressupost', sa.Float(), nullable=False),
        sa.Column('data_inici', sa.DateTime(), nullable=False),
        sa.Column('data_fi', sa.DateTime(), nullable=False),
        sa.Column('num_invitats', sa.Integer(), nullable=False),
        sa.Column('id', sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.Column('account_id', sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.ForeignKeyConstraint(['account_id'], ['account.id'], ),
        sa.PrimaryKeyConstraint('id')
        )

    if 'raider' not in existing_tables:
        op.create_table('raider',
        sa.Column('num_integrantes', sa.Integer(), nullable=False),
        sa.Column('equipo', sa.JSON(), nullable=True),
        sa.Column('solicitar_cancion_nueva', sa.Boolean(), nullable=True),
        sa.Column('coste_cancion_nueva', sa.Float(), nullable=True),
        sa.Column('equipo_propio', sa.Boolean(), nullable=True),
        sa.Column('coste_equipo_propio', sa.Float(), nullable=True),
        sa.Column('disponible_sin_equipo', sa.Boolean(), nullable=True),
        sa.Column('dimensiones_escenario', sa.JSON(), nullable=True),
        sa.Column('condiciones', sa.JSON(), nullable=True),
        sa.Column('id', sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.Column('account_id', sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.ForeignKeyConstraint(['account_id'], ['account.id'], ),
        sa.PrimaryKeyConstraint('id')
        )

    if 'service' not in existing_tables:
        op.create_table('service',
        sa.Column('type', sa.Enum('ESPAI', 'CATERING', 'MOBILIARI_DECORACIO', 'MUSICA', 'FOTOGRAFIA', name='servicetype'), nullable=False),
        sa.Column('name', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column('price', sa.Float(), nullable=True),
        sa.Column('images', sa.JSON(), nullable=True),
        sa.Column('description', sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column('availability', sa.Boolean(), nullable=True),
        sa.Column('availability_rule', sa.JSON(), nullable=True),
        sa.Column('services_extra', sa.JSON(), nullable=True),
        sa.Column('address', sa.JSON(), nullable=True),
        sa.Column('id', sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.Column('account_id', sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.Column('espai_id', sqlmodel.sql.sqltypes.GUID(), nullable=True),
        sa.Column('catering_id', sqlmodel.sql.sqltypes.GUID(), nullable=True),
        sa.Column('mobiliari_decoracio_id', sqlmodel.sql.sqltypes.GUID(), nullable=True),
        sa.Column('musica_id', sqlmodel.sql.sqltypes.GUID(), nullable=True),
        sa.Column('fotografia_id', sqlmodel.sql.sqltypes.GUID(), nullable=True),
        sa.ForeignKeyConstraint(['account_id'], ['account.id'], ),
        sa.PrimaryKeyConstraint('id')
        )
        op.create_index(op.f('ix_service_name'), 'service', ['name'], unique=False)

    if 'catering' not in existing_tables:
        op.create_table('catering',
        sa.Column('tipo_entrega', sa.Enum('ESTABLECIMIENTO', 'ENTREGA', 'SERVICIO_DOMICILIO', name='tipoentrega'), nullable=False),
        sa.Column('tipo_catering', sa.Enum('MESA_SERVIDO', 'MESA_COMPARTIDO', 'MESA_REDONDA', 'BANQUETE_IMPERIAL', 'GUERIDON', 'BUFFET', 'ESTACIONES', 'COCTEL', 'FINGER_FOOD', 'MIXTO_COCTEL_MESA', 'MIXTO_COCTEL_BUFFET', 'SHOW_COOKING', 'FOOD_TRUCK', name='tipocatering'), nullable=True),
        sa.Column('min_comensales', sa.Integer(), nullable=False),
        sa.Column('max_comensales', sa.Integer(), nullable=False),
        sa.Column('duracion', sa.Float(), nullable=False),
        sa.Column('alergenos', sa.JSON(), nullable=True),
        sa.Column('caracteristicas', sa.JSON(), nullable=True),
        sa.Column('id', sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.Column('menu', sa.JSON(), nullable=True),
        sa.Column('articulo', sa.JSON(), nullable=True),
        sa.ForeignKeyConstraint(['id'], ['service.id'], ),
        sa.PrimaryKeyConstraint('id')
        )

    if 'espai' not in existing_tables:
        op.create_table('espai',
        sa.Column('espai_type', sa.Enum('MASIA', 'RESTAURANTE', 'HOTEL', 'LOCAL', 'SALA', 'COMEDOR', 'DISCOTECA', 'ESPACIO_DE_ACTIVIDADES', 'TERRAZA', 'ATICO', 'CASTILLO', 'JARDIN', 'CASA_RURAL', 'FINCA', 'MOLINO', 'VILLA', 'HACIENDA', 'ESPACIO_SINGULAR', 'PALACIO', 'BOSQUE', 'OTROS', name='espaitype'), nullable=False),
        sa.Column('capacitat_min', sa.Integer(), nullable=False),
        sa.Column('capacitat_max', sa.Integer(), nullable=False),
        sa.Column('caracteristicas', sa.JSON(), nullable=True),
        sa.Column('id', sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.ForeignKeyConstraint(['id'], ['service.id'], ),
        sa.PrimaryKeyConstraint('id')
        )

    if 'fotografia' not in existing_tables:
        op.create_table('fotografia',
        sa.Column('fotografia_type', sa.Enum('FOTOGRAFIA', 'VIDEO', 'SERVICIO_ESPECIAL', name='fotografiatype'), nullable=False),
        sa.Column('servicio_especial_type', sa.Enum('IMPRESION_INSTANTANEA', 'CABINA', 'ESPEJO_MAGICO', 'VIDEO_360', 'GIFT_BOX', 'VIRTUAL', 'CAMARA_OCULTA', name='servicioespecial'), nullable=True),
        sa.Column('duracion', sa.Float(), nullable=False),
        sa.Column('caracteristicas', sa.JSON(), nullable=True),
        sa.Column('id', sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.Column('raider_id', sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.ForeignKeyConstraint(['id'], ['service.id'], ),
        sa.ForeignKeyConstraint(['raider_id'], ['raider.id'], ),
        sa.PrimaryKeyConstraint('id')
        )

    if 'mobiliaridecoracio' not in existing_tables:
        op.create_table('mobiliaridecoracio',
        sa.Column('service_type', sa.Enum('DECORACION', 'MOBILIARIO', name='mobiliaridecoraciotype'), nullable=False),
        sa.Column('tipologia', sa.Enum('FLORES', 'GLOBOS', 'LUCES_GUINALDA', 'LUCES_LED', 'FUNDAS_SILLA', 'COJINES_MANTAS', 'TELAS', 'CARTELES', 'PHOTOCALL', 'DISFRACES', 'VASOS', 'VAJILLA_BANDEJAS', 'MANTELES_SERVILLETAS', 'UTENSILIOS_COCINA', 'ELECTRODOMESTICOS_COCINA', 'BUFET', 'FOODTRUCK', 'BARBACOA', 'MESAS', 'SILLAS_TABURETES', 'TRONAS', 'BARRILES_TONELADAS_CHILL_OUT', 'ESCALERAS_VIGAS', 'PALES', 'CATENARIAS', 'COLGADORES_GUARDARROPAS', 'CUBIERTA', 'CRISTALERA', 'CARPAS', 'TOLDOS_PARASOLES', 'PAREDES', 'SUELOS', 'EDIFICACIONES_TEMPORALES', 'STANDS', 'TOCADOR_MAQUILLAJE', 'ESPEJOS', 'VITRINAS', 'MOSTRADORES_BARRAS', 'IGLOO', 'ESTUFAS_CALEFACTORES', 'VENTILADORES_AIRE', 'PIZARRAS', 'PANTALLAS', 'PROYECTORES', 'ALTAVOCES', 'MICROFONOS', 'FOCO', 'BOLA_DISCO', 'TABLA_DJ', 'ELECTRICIDAD_ENCHUFES', 'AIRES_FAROLILLOS', 'LIMPIEZA', 'GRADAS_TRIBUNAS', 'JUEGOS', 'ATRACCIONES', 'MANIQUIS', 'MAQUINAS_COMIDA', 'WC', 'CONTENEDORES_PAPELERAS', name='tipomobiliaridecoracio'), nullable=False),
        sa.Column('is_rental', sa.Boolean(), nullable=False),
        sa.Column('cantidad_min', sa.Integer(), nullable=False),
        sa.Column('cantidad_max', sa.Integer(), nullable=False),
        sa.Column('subtipologia', sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column('forma', sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column('modality', sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column('color', sa.JSON(), nullable=True),
        sa.Column('material', sa.JSON(), nullable=True),
        sa.Column('style', sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column('size', sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column('caracteristicas', sa.JSON(), nullable=True),
        sa.Column('complement', sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column('id', sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.ForeignKeyConstraint(['id'], ['service.id'], ),
        sa.PrimaryKeyConstraint('id')
        )

    if 'musica' not in existing_tables:
        op.create_table('musica',
        sa.Column('musica_type', sa.Enum('DJ', 'MUSICO', name='musicaestilo'), nullable=False),
        sa.Column('canciones', sa.Enum('PROPIAS', 'VERSIONES', name='canciones'), nullable=False),
        sa.Column('generos', sa.JSON(), nullable=True),
        sa.Column('duracion', sa.Float(), nullable=False),
        sa.Column('instrumentos', sa.JSON(), nullable=True),
        sa.Column('caracteristicas', sa.JSON(), nullable=True),
        sa.Column('id', sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.Column('raider_id', sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.ForeignKeyConstraint(['id'], ['service.id'], ),
        sa.ForeignKeyConstraint(['raider_id'], ['raider.id'], ),
        sa.PrimaryKeyConstraint('id')
        )

    # Eliminar tabla user_downgraded si existe
    if 'user_downgraded' in existing_tables:
        op.drop_table('user_downgraded')

    # Crear índices solo si no existen
    if 'ix_user_cif' not in [index['name'] for index in inspector.get_indexes('user')]:
        op.create_index(op.f('ix_user_cif'), 'user', ['cif'], unique=True)
    if 'ix_user_dni' not in [index['name'] for index in inspector.get_indexes('user')]:
        op.create_index(op.f('ix_user_dni'), 'user', ['dni'], unique=True)
    if 'ix_user_email' not in [index['name'] for index in inspector.get_indexes('user')]:
        op.create_index(op.f('ix_user_email'), 'user', ['email'], unique=True)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    conn = op.get_bind()
    inspector = sa.inspect(conn)
    existing_tables = inspector.get_table_names()
    existing_indexes = {table: [index['name'] for index in inspector.get_indexes(table)] for table in inspector.get_table_names()}

    # Eliminar índices solo si existen
    if 'user' in existing_tables:
        if 'ix_user_email' in existing_indexes.get('user', []):
            op.drop_index(op.f('ix_user_email'), table_name='user')
        if 'ix_user_dni' in existing_indexes.get('user', []):
            op.drop_index(op.f('ix_user_dni'), table_name='user')
        if 'ix_user_cif' in existing_indexes.get('user', []):
            op.drop_index(op.f('ix_user_cif'), table_name='user')

    # Eliminar tablas solo si existen
    if 'musica' in existing_tables:
        op.drop_table('musica')
    if 'mobiliaridecoracio' in existing_tables:
        op.drop_table('mobiliaridecoracio')
    if 'fotografia' in existing_tables:
        op.drop_table('fotografia')
    if 'espai' in existing_tables:
        op.drop_table('espai')
    if 'catering' in existing_tables:
        op.drop_table('catering')
    
    # Eliminar tablas base solo si existen
    if 'service' in existing_tables:
        if 'ix_service_name' in existing_indexes.get('service', []):
            op.drop_index(op.f('ix_service_name'), table_name='service')
        op.drop_table('service')
    if 'raider' in existing_tables:
        op.drop_table('raider')
    if 'event' in existing_tables:
        op.drop_table('event')
    
    # Crear tabla de downgrade solo si no existe
    if 'user_downgraded' not in existing_tables:
        op.create_table('user_downgraded',
        sa.Column('dummy', sa.BOOLEAN(), nullable=True)
        )
    # ### end Alembic commands ###
