"""add finca to tipuespaipropi

Revision ID: 8ec6b68e357a
Revises: 2cc823242981
Create Date: 2025-05-21 19:41:47.317104

"""
from alembic import op
import sqlalchemy as sa
import sqlmodel.sql.sqltypes


# revision identifiers, used by Alembic.
revision = '8ec6b68e357a'
down_revision = '2cc823242981'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    # Para SQLite, recrear la tabla con el nuevo valor
    # 1. Crear tabla temporal con la nueva definición
    conn = op.get_bind()
    inspector = sa.inspect(conn)
    existing_tables = inspector.get_table_names()

    if 'espai_propi_temp' in existing_tables:
        op.drop_table('espai_propi_temp')
    op.create_table('espai_propi_temp',
        sa.Column('nombre', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column('tipus', sa.Enum('SALA_PRIVADA', 'TERRAZA', 'SALON', 'CASA_PARTICULAR', 
                                 'JARDIN_PRIVADO', 'AZOTEA', 'PISO', 'CASA_RURAL', 
                                 'NAVE_INDUSTRIAL', 'PARCELA', 'LOCAL_PROPIO', 'MASIA', 
                                 'OTRO', 'FINCA', 'finca', name='tipusespaipropi'), nullable=False),
        sa.Column('address', sa.JSON(), nullable=True),
        sa.Column('descripcion', sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column('capacitat_aproximada', sa.Integer(), nullable=True),
        sa.Column('caracteristicas', sa.JSON(), nullable=True),
        sa.Column('id', sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.Column('account_id', sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.ForeignKeyConstraint(['account_id'], ['account.id'], ),
        sa.PrimaryKeyConstraint('id')
    )
    
    # 2. Copiar datos de la tabla original a la temporal
    op.execute("""
        INSERT INTO espai_propi_temp 
        SELECT * FROM espai_propi
    """)
    
    # 3. Eliminar la tabla original
    op.drop_table('espai_propi')
    
    # 4. Renombrar la tabla temporal a la original
    op.rename_table('espai_propi_temp', 'espai_propi')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    # No podemos eliminar valores de un enum en PostgreSQL
    pass
    # ### end Alembic commands ###
