""" Main API routes definition """
from fastapi import APIRouter
from app.api.routes import (login, users, assistant, accounts, events, service, espai, raider, musica, catering, mobiliari_decoracio, fotografias, 
                            event_service, availability, espai_propi, upload)

api_router = APIRouter()
api_router.include_router(login.router, tags=["login"])
api_router.include_router(users.router, prefix="/users", tags=["users"])
api_router.include_router(assistant.router, prefix="/assistant", tags=["assistant"])
api_router.include_router(accounts.router, prefix="/accounts", tags=["accounts"])
api_router.include_router(events.router, prefix="/events", tags=["events"])
api_router.include_router(service.router, prefix="/service", tags=["service"])
api_router.include_router(espai.router, prefix="/espai", tags=["espai"])
api_router.include_router(raider.router, prefix="/raider", tags=["raider"])
api_router.include_router(musica.router, prefix="/musica", tags=["musica"])
api_router.include_router(mobiliari_decoracio.router, prefix="/mobiliari_decoracio", tags=["mobiliari_decoracio"])
api_router.include_router(catering.router, prefix="/catering", tags=["catering"]) 
api_router.include_router(fotografias.router, prefix="/fotografias", tags=["fotografias"])
api_router.include_router(event_service.router, prefix="/event_service", tags=["event_service"])
api_router.include_router(availability.router, prefix="/availability", tags=["availability"])
api_router.include_router(espai_propi.router, prefix="/espai-propi", tags=["espai-propi"])
api_router.include_router(upload.router, prefix="/upload", tags=["upload"])
