from fastapi import APIRouter, UploadFile, File, HTTPException
from app.services.s3_service import S3Service

router = APIRouter()
s3_service = S3Service()

@router.post("/upload-image/")
async def upload_image(file: UploadFile = File(...)):
    try:
        url = s3_service.upload_fileobj(file.file, filename=file.filename, content_type=file.content_type)
        return {"url": url}
    except Exception as e:
        raise HTTPException(status_code=500, detail=str(e))