import Vue from 'vue'
import Router from 'vue-router'
import Login from '../components/login.vue'
import Signup from '../components/signup.vue'
import WelcomePage from '../components/welcomePage.vue'
import MainPageVendor from '../components/mainPageVendor.vue'
import MainPageClient from '../components/mainPageClient.vue'
import CreateEvent from '../components/createEvent.vue'
import Services from '../components/services.vue'
import DetallesService from '../components/detallesService.vue'
import MyDetallesService from '../components/mydetallesService.vue'
import CreateService from '../components/createServices.vue'
import Profile from '../components/profile.vue'
import EditService from '../components/edit_services/EditServices.vue'
import EventService from '../components/eventServices.vue'
import MyEvents from '@/components/myEvents.vue'
import MyServices from '@/components/myServices.vue'
import MyProfile from '@/components/myProfile.vue'
import IntelligentAssistant from '@/components/IntelligentAssistant.vue'
import Payment from '@/components/Payment.vue'
import CreateEspaiPropi from '@/components/event_services/CreateEspaiPropi.vue'
import EditEspaiPropi from '@/components/event_services/EditEspaiPropi.vue'
import MyEspaisPropis from '@/components/event_services/MyEspaisPropis.vue'
import Contacto from '@/components/Contacto.vue'
import AyudaFAQ from '@/components/AyudaFAQ.vue'

import axios from 'axios'
import userServices from '../services/UserServices.js'

Vue.use(Router)
const router = new Router({
  mode: 'history',
  routes: [
    {
      path: '/',
      name: 'welcomePage',
      component: WelcomePage,
      meta: { requiresAuth: false } // Ruta pública
    },
    {
      path: '/login',
      name: 'login',
      component: Login,
      meta: { requiresAuth: false } // Ruta pública
    },
    {
      path: '/signup',
      name: 'signup',
      component: Signup,
      meta: { requiresAuth: false } // Ruta pública
    },
    {
      path: '/mainPageVendor',
      name: 'mainPageVendor',
      component: MainPageVendor,
      meta: { requiresAuth: true } // Requiere autenticación
    },
    {
      path: '/mainPageClient',
      name: 'mainPageClient',
      component: MainPageClient,
      meta: { requiresAuth: true } // Requiere autenticación
    },
    {
      path: '/createEvent',
      name: 'createEvent',
      component: CreateEvent,
      meta: { requiresAuth: true } // Requiere autenticación
    },
    {
      path: '/services',
      name: 'services',
      component: Services,
      meta: { requiresAuth: true, keepAlive: true }
    },
    {
      path: '/detallesService/:id',
      name: 'detallesService',
      component: DetallesService,
      meta: { requiresAuth: true } // Requiere autenticación
    },
    {
      path: '/editService/:type_service/:service_id',
      name: 'editService',
      component: EditService,
      props: true,
      meta: { requiresAuth: true } // Requiere autenticación
    },
    {
      path: '/mydetallesService/:id',
      name: 'mydetallesService',
      component: MyDetallesService,
      meta: { requiresAuth: true } // Requiere autenticación
    },
    {
      path: '/createService',
      name: 'createService',
      component: CreateService,
      meta: { requiresAuth: true } // Requiere autenticación
    },
    {
      path: '/profile/:id',
      name: 'profile',
      component: Profile,
      meta: { requiresAuth: true } // Requiere autenticación
    },
    {
      path: '/eventServices/:id',
      name: 'eventServices',
      component: EventService,
      props: true,
      meta: { requiresAuth: true } // Requiere autenticación
    },
    {
      path: '/myEvents',
      name: 'myEvents',
      component: MyEvents,
      meta: { requiresAuth: true }
    },
    {
      path: '/myServices',
      name: 'myServices',
      component: MyServices,
      meta: { requiresAuth: true }
    },
    {
      path: '/myProfile',
      name: 'myProfile',
      component: MyProfile,
      meta: { requiresAuth: true }
    },
    {
      path: '/intelligentAssistant',
      name: 'intelligentAssistant',
      component: IntelligentAssistant,
      meta: { requiresAuth: true }
    },
    {
      path: '/payment/:uid',
      name: 'Payment',
      component: Payment,
      meta: { requiresAuth: true }
    },
    {
      path: '/createEspaiPropi',
      name: 'CreateEspaiPropi',
      component: CreateEspaiPropi,
      meta: { requiresAuth: true }
    },
    {
      path: '/editEspaiPropi/:id',
      name: 'EditEspaiPropi',
      component: EditEspaiPropi,
      meta: { requiresAuth: true }
    },
    {
      path: '/myEspaisPropis',
      name: 'myEspaisPropis',
      component: MyEspaisPropis,
      meta: { requiresAuth: true }
    },
    {
      path: '/contacto',
      name: 'contacto',
      component: Contacto
    },
    {
      path: '/ayudaFAQ',
      name: 'ayudaFAQ',
      component: AyudaFAQ
    }
  ]
})

router.beforeEach(async (to, from, next) => {
  // Obtenemos el token del localStorage
  const token = localStorage.getItem('token')
  const requiresAuth = to.matched.some(record => record.meta.requiresAuth)

  // Si la ruta requiere autenticación y no hay token, redirigimos al login
  if (requiresAuth && !token) {
    console.log('Redirigiendo a /login...')
    return next('/login')
  }

  // Si hay un token, configuramos axios para usarlo
  if (token) {
    axios.defaults.headers.common['Authorization'] = `Bearer ${token}`

    try {
      // Obtenemos la información del usuario
      const userInfo = await userServices.getActualUser()

      // Restricción de acceso según el rol del usuario
      if (userInfo) {
        // Rutas prohibidas para usuarios no vendor
        const vendorOnlyRoutes = ['/mainPageVendor', '/myServices', '/mydetallesService', 'myRaider']
        if (!userInfo.role.includes('vendor') && vendorOnlyRoutes.includes(to.path)) {
          console.log('Acceso denegado: Usuario no es proveedor.')
          return next('/mainPageClient') // Redirigir al área del usuario normal
        }

        // Rutas prohibidas para vendor
        const clientOnlyRoutes = ['/mainPageClient']
        if (userInfo.role.includes('vendor') && clientOnlyRoutes.includes(to.path)) {
          console.log('Acceso denegado: Usuario es proveedor.')
          return next('/mainPageVendor') // Redirigir al área del editor
        }
      }

      // Si el usuario ya está autenticado y trata de acceder a login, signup, o mainPage_guest, redirigimos a su página principal
      if (
        (to.path === '/login' || to.path === '/signup' || to.path === '/') &&
        userInfo
      ) {
        if (userInfo.role.includes('vendor')) {
          console.log('Usuario autenticado como proveedor, redirigiendo a /mainPageVendor...')
          return next('/mainPageVendor')
        } else {
          console.log('Usuario autenticado como cliente, redirigiendo a /mainPageClient...')
          return next('/mainPageClient')
        }
      }
    } catch (error) {
      // Si hay un error al obtener la información del usuario, limpiamos el token
      console.error('Error al obtener información del usuario:', error)
      localStorage.removeItem('token')
      delete axios.defaults.headers.common['Authorization']

      // Redirigimos al login si hay error
      if (requiresAuth) {
        return next('/login')
      }
    }
  }

  // Continuar con la navegación si no hay problemas
  next()
})

export default router
