import http from '../http-common'

class AccountService {
  create (data) {
    const accountData = { id: data }
    return http.post('/api/v1/accounts/create_account', accountData)
      .then((res) => res.data)
      .catch((error) => {
        console.error('Error al crear la cuenta:', error.response?.data || error.message)
        throw error
      })
  }

  getActualAccount () {
    const token = localStorage.getItem('token')
    return http.get('/api/v1/accounts/me', {
      headers: {
        'Authorization': `Bearer ${token}`
      }
    })
      .then((res) => res.data)
      .catch((error) => {
        console.error('Error al obtener los datos del usuario:', error.response?.data || error.message)
        throw error
      })
  }

  getAccountById (accountId) {
    const token = localStorage.getItem('token')
    return http.get(`/api/v1/accounts/by_id/${accountId}`, {
      headers: {
        'Authorization': `Bearer ${token}`
      }
    })
      .then((res) => res.data)
      .catch((error) => {
        console.error('Error al obtener los datos del usuario:', error.response?.data || error.message)
        throw error
      })
  }

  updateAccount (data) {
    const token = localStorage.getItem('token')
    return http.patch('/api/v1/accounts/me', data, {
      headers: {
        'Authorization': `Bearer ${token}`
      }
    })
      .then((res) => res.data)
      .catch((error) => {
        console.error('Error al actualizar los datos del usuario:', error.response?.data || error.message)
        throw error
      })
  }

  getAllAccounts () {
    const token = localStorage.getItem('token')
    return http.get('/api/v1/accounts/get_all_accounts', {
      headers: {
        'Authorization': `Bearer ${token}`
      }
    })
      .then((res) => res.data)
      .catch((error) => {
        console.error('Error al obtener todas las cuentas:', error.response?.data || error.message)
        throw error
      })
  }

  getAllAccountsByText (text) {
    const token = localStorage.getItem('token')
    return http.get(`/api/v1/accounts/get_accounts_by_text/${text}`, {
      headers: {
        'Authorization': `Bearer ${token}`
      }
    })
      .then((res) => res.data)
      .catch((error) => {
        console.error('Error al obtener las cuentas por rol:', error.response?.data || error.message)
        throw error
      })
  }

  deleteAccount () {
    const token = localStorage.getItem('token')
    return http.delete('/api/v1/accounts/me', {
      headers: {
        'Authorization': `Bearer ${token}`
      }
    })
      .then((res) => res.data)
      .catch((error) => {
        console.error('Error al eliminar la cuenta:', error.response?.data || error.message)
        throw error
      })
  }

  getOrCreateAccount () {
    const token = localStorage.getItem('token')
    return http.get('/api/v1/accounts/create-if-not-exists', {
      headers: {
        'Authorization': `Bearer ${token}`
      }
    })
      .then((res) => res.data)
      .catch((error) => {
        console.error('Error al obtener o crear la cuenta:', error.response?.data || error.message)
        throw error
      })
  }
}

export default new AccountService()
