import http from '@/http-common'

class CateringService {
  // Obtener todos los servicios de catering
  getAllCaterings (skip = 0, limit = 10) {
    return http.get(`/api/v1/catering/all/?skip=${skip}&limit=${limit}`)
      .then(res => {
        return res.data
      })
      .catch(error => {
        console.error('Error fetching caterings', error)
        throw error
      })
  }

  // Obtener mis servicios de catering
  getAllMyCaterings (skip = 0, limit = 10) {
    const token = localStorage.getItem('token')
    return http.get(`/api/v1/catering/all_me/?skip=${skip}&limit=${limit}`, {
      headers: {
        'Authorization': `Bearer ${token}`
      }
    })
      .then(res => {
        return res.data
      })
      .catch(error => {
        console.error('Error fetching my caterings', error)
        throw error
      })
  }

  // Obtener un servicio de catering por ID
  getCateringById (id) {
    return http.get(`/api/v1/catering/by_id/${id}`)
      .then(res => {
        return res.data
      })
      .catch(error => {
        console.error('Error fetching catering', error)
        throw error
      })
  }

  // Crear un nuevo servicio de catering
  createCatering (cateringData) {
    const token = localStorage.getItem('token')
    return http.post('/api/v1/catering/', cateringData, {
      headers: {
        'Authorization': `Bearer ${token}`
      }
    })
      .then(res => {
        return res.data
      })
      .catch(error => {
        console.error('Error creating catering', error)
        throw error
      })
  }

  // Actualizar un servicio de catering
  updateCatering (id, cateringData) {
    const token = localStorage.getItem('token')
    return http.put(`/api/v1/catering/${id}`, cateringData, {
      headers: {
        'Authorization': `Bearer ${token}`
      }
    })
      .then(res => {
        return res.data
      })
      .catch(error => {
        console.error('Error updating catering', error)
        throw error
      })
  }

  // Actualizar parcialmente un servicio de catering
  patchCatering (id, cateringData) {
    const token = localStorage.getItem('token')
    return http.patch(`/api/v1/catering/${id}`, cateringData, {
      headers: {
        'Authorization': `Bearer ${token}`
      }
    })
      .then(res => {
        return res.data
      })
      .catch(error => {
        console.error('Error patching catering', error)
        throw error
      })
  }

  // Eliminar un servicio de catering
  deleteCatering (id) {
    const token = localStorage.getItem('token')
    return http.delete(`/api/v1/catering/${id}`, {
      headers: {
        'Authorization': `Bearer ${token}`
      }
    })
      .then(res => {
        return res.data
      })
      .catch(error => {
        console.error('Error deleting catering', error)
        throw error
      })
  }

  // Filtrar servicios de catering
  filterCaterings (params) {
    const queryParams = new URLSearchParams()
    if (params.tipo_entrega) queryParams.append('tipo_entrega', params.tipo_entrega)
    if (params.tipo_catering) queryParams.append('tipo_catering', params.tipo_catering)
    if (params.num_comensales) queryParams.append('num_comensales', params.num_comensales)
    if (params.duracion) queryParams.append('duracion', params.duracion)
    if (params.menu_or_articulo !== undefined) queryParams.append('menu_or_articulo', params.menu_or_articulo)
    if (params.tipo_menu) queryParams.append('tipo_menu', params.tipo_menu)
    if (params.tipo_articulo) queryParams.append('tipo_articulo', params.tipo_articulo)
    if (params.skip) queryParams.append('skip', params.skip)
    if (params.limit) queryParams.append('limit', params.limit)

    return http.get(`/api/v1/catering/filter?${queryParams.toString()}`)
      .then(res => {
        return res.data
      })
      .catch(error => {
        console.error('Error filtering caterings', error)
        throw error
      })
  }

  // Filtrar mis servicios de catering
  filterMyCaterings (params) {
    const token = localStorage.getItem('token')
    const queryParams = new URLSearchParams()
    if (params.tipo_entrega) queryParams.append('tipo_entrega', params.tipo_entrega)
    if (params.tipo_catering) queryParams.append('tipo_catering', params.tipo_catering)
    if (params.num_comensales) queryParams.append('num_comensales', params.num_comensales)
    if (params.duracion) queryParams.append('duracion', params.duracion)
    if (params.menu_or_articulo !== undefined) queryParams.append('menu_or_articulo', params.menu_or_articulo)
    if (params.tipo_menu) queryParams.append('tipo_menu', params.tipo_menu)
    if (params.tipo_articulo) queryParams.append('tipo_articulo', params.tipo_articulo)
    if (params.skip) queryParams.append('skip', params.skip)
    if (params.limit) queryParams.append('limit', params.limit)

    return http.get(`/api/v1/catering/filter_me?${queryParams.toString()}`, {
      headers: {
        'Authorization': `Bearer ${token}`
      }
    })
      .then(res => {
        return res.data
      })
      .catch(error => {
        console.error('Error filtering my caterings', error)
        throw error
      })
  }
}

export default new CateringService()
