import http from '../http-common'

class EspaiPropiServices {
  async getMyEspaiPropis () {
    try {
      const token = localStorage.getItem('token')
      const response = await http.get(`/api/v1/espai-propi/my-espai-propi?skip=0&limit=100`, {
        headers: {
          'Authorization': `Bearer ${token}`
        }
      })
      return response.data
    } catch (error) {
      console.error('Error al obtener los espacios propios:', error)
      throw error
    }
  }

  async getEspaiPropiById (id) {
    try {
      const token = localStorage.getItem('token')
      const response = await http.get(`/api/v1/espai-propi/espai-propi/${id}`, {
        headers: {
          'Authorization': `Bearer ${token}`
        }
      })
      return response.data
    } catch (error) {
      console.error('Error al obtener el espacio propio:', error)
      throw error
    }
  }

  async createEspaiPropi (espaiPropiData) {
    try {
      const token = localStorage.getItem('token')
      const response = await http.post(`/api/v1/espai-propi/espai-propi`, espaiPropiData, {
        headers: {
          'Authorization': `Bearer ${token}`
        }
      })
      return response.data
    } catch (error) {
      console.error('Error al crear el espacio propio:', error)
      throw error
    }
  }

  async updateEspaiPropi (id, espaiPropiData) {
    try {
      const token = localStorage.getItem('token')
      const response = await http.patch(`/api/v1/espai-propi/espai-propi/${id}`, espaiPropiData, {
        headers: {
          'Authorization': `Bearer ${token}`
        }
      })
      return response.data
    } catch (error) {
      console.error('Error al actualizar el espacio propio:', error)
      throw error
    }
  }

  async deleteEspaiPropi (id) {
    try {
      const token = localStorage.getItem('token')
      const response = await http.delete(`/api/v1/espai-propi/espai-propi/${id}`, {
        headers: {
          'Authorization': `Bearer ${token}`
        }
      })
      return response.data
    } catch (error) {
      console.error('Error al eliminar el espacio propio:', error)
      throw error
    }
  }
}

export default new EspaiPropiServices()
