import http from '../http-common'

class EventServiceServices {
  async addServiceToEvent (data) {
    try {
      const response = await http.post(`/api/v1/event_service/events/services`, data, {
        headers: {
          'Content-Type': 'application/json'
        }
      })
      return response.data
    } catch (error) {
      console.error('Error al añadir el servicio al evento:', error)
      throw error
    }
  }

  async updateServiceInEvent (eventId, serviceId, data) {
    try {
      const response = await http.put(`/api/v1/event_service/events/${eventId}/services/${serviceId}`, data, {
        headers: {
          'Content-Type': 'application/json'
        }
      })
      return response.data
    } catch (error) {
      console.error('Error al actualizar el servicio en el evento:', error)
      throw error
    }
  }

  async removeServiceFromEvent (eventId, serviceId) {
    try {
      const response = await http.delete(`/api/v1/event_service/events/${eventId}/services/${serviceId}`, {
        headers: {
          'Content-Type': 'application/json'
        }
      })
      return response.data
    } catch (error) {
      console.error('Error al eliminar el servicio del evento:', error)
      throw error
    }
  }

  async getEventServices (eventId, skip = 0, limit = 100) {
    try {
      const response = await http.get(`/api/v1/event_service/events/${eventId}/services?skip=${skip}&limit=${limit}`, {
        headers: {
          'Content-Type': 'application/json'
        }
      })
      return response.data.data
    } catch (error) {
      console.error('Error al obtener los servicios del evento:', error)
      throw error
    }
  }

  async getEventServiceById (eventId, serviceId) {
    try {
      const response = await http.get(`/api/v1/event_service/events/${eventId}/services/${serviceId}`, {
        headers: {
          'Content-Type': 'application/json'
        }
      })
      return response.data
    } catch (error) {
      console.error('Error al obtener los detalles del servicio en el evento:', error)
      throw error
    }
  }

  async getAllServicesForEvent (eventId) {
    try {
      const response = await http.get(`/api/v1/event_service/events/${eventId}/all-services`, {
        headers: {
          'Content-Type': 'application/json'
        }
      })
      return response.data
    } catch (error) {
      console.error('Error al obtener todos los servicios del evento:', error)
      throw error
    }
  }

  async getEventsForService (serviceId) {
    try {
      const response = await http.get(`/api/v1/event_service/services/${serviceId}/events`, {
        headers: {
          'Content-Type': 'application/json'
        }
      })
      return response.data
    } catch (error) {
      console.error('Error al obtener los eventos del servicio:', error)
      throw error
    }
  }

  async checkServiceAvailability (serviceId, eventData) {
    try {
      const response = await http.post(`/api/v1/event_service/service-availability/${serviceId}`, eventData, {
        headers: {
          'Content-Type': 'application/json'
        }
      })
      return response.data
    } catch (error) {
      console.error('Error al comprobar la disponibilidad del servicio:', error)
      throw error
    }
  }
}

export default new EventServiceServices()
