import http from '../http-common'

class EventService {
  // Obtener todos los eventos del usuario
  async getMyEvents () {
    try {
      const response = await http.get('/api/v1/events/my_events')
      return response.data.data
    } catch (error) {
      console.error('Error al obtener los eventos:', error)
      throw error
    }
  }

  // Obtener un evento específico por ID
  async getById (eventId) {
    try {
      const response = await http.get(`/api/v1/events/events/${eventId}`)
      return response.data
    } catch (error) {
      console.error('Error al obtener el evento:', error)
      throw error
    }
  }

  // Obtener eventos por cuenta
  async getByAccountId (accountId) {
    try {
      const token = localStorage.getItem('token')
      const response = await http.get(`/api/v1/events/by_account/${accountId}`, {
        headers: {
          'Authorization': `Bearer ${token}`
        }
      })
      return response.data
    } catch (error) {
      console.error('Error al obtener los eventos por cuenta:', error)
      throw error
    }
  }

  // Crear un nuevo evento
  async create (eventData) {
    try {
      const response = await http.post('/api/v1/events/', eventData)
      return response.data
    } catch (error) {
      console.error('Error al crear el evento:', error)
      throw error
    }
  }

  // Actualizar un evento
  async update (eventId, eventData) {
    try {
      const response = await http.patch(`/api/v1/events/${eventId}`, eventData)
      return response.data
    } catch (error) {
      console.error('Error al actualizar el evento:', error)
      throw error
    }
  }

  // Eliminar un evento
  async delete (eventId) {
    try {
      const response = await http.delete(`/api/v1/events/${eventId}`)
      return response.data
    } catch (error) {
      console.error('Error al eliminar el evento:', error)
      throw error
    }
  }

  // Filtrar eventos
  async filterEvents (filters) {
    try {
      const response = await http.get('/api/v1/events/filter', { params: filters })
      return response.data
    } catch (error) {
      console.error('Error al filtrar eventos:', error)
      throw error
    }
  }

  // Filtrar mis eventos
  async filterMyEvents (filters) {
    try {
      const response = await http.get('/api/v1/events/filter/me', { params: filters })
      return response.data
    } catch (error) {
      console.error('Error al filtrar mis eventos:', error)
      throw error
    }
  }
}

export default new EventService()
