import http from '@/http-common'

class MobiliariDecoracioService {
  // Obtener todos los servicios de mobiliario y decoración
  getAllMobiliaris (skip = 0, limit = 10) {
    return http.get(`/api/v1/mobiliari_decoracio/all/?skip=${skip}&limit=${limit}`)
      .then(res => {
        return res.data
      })
      .catch(error => {
        console.error('Error fetching mobiliaris', error)
        throw error
      })
  }

  // Obtener mis servicios de mobiliario y decoración
  getAllMyMobiliaris (skip = 0, limit = 10) {
    const token = localStorage.getItem('token')
    return http.get(`/api/v1/mobiliari_decoracio/all_me/?skip=${skip}&limit=${limit}`, {
      headers: {
        'Authorization': `Bearer ${token}`
      }
    })
      .then(res => {
        return res.data
      })
      .catch(error => {
        console.error('Error fetching my mobiliaris', error)
        throw error
      })
  }

  // Obtener un servicio de mobiliario y decoración por ID
  getMobiliariById (id) {
    return http.get(`/api/v1/mobiliari_decoracio/by_id/${id}`)
      .then(res => {
        return res.data
      })
      .catch(error => {
        console.error('Error fetching mobiliari', error)
        throw error
      })
  }

  // Crear un nuevo servicio de mobiliario y decoración
  createMobiliari (mobiliariData) {
    const token = localStorage.getItem('token')
    return http.post('/api/v1/mobiliari_decoracio/', mobiliariData, {
      headers: {
        'Authorization': `Bearer ${token}`
      }
    })
      .then(res => {
        return res.data
      })
      .catch(error => {
        console.error('Error creating mobiliari', error)
        throw error
      })
  }

  // Actualizar un servicio de mobiliario y decoración
  updateMobiliari (id, mobiliariData) {
    const token = localStorage.getItem('token')
    return http.put(`/api/v1/mobiliari_decoracio/${id}`, mobiliariData, {
      headers: {
        'Authorization': `Bearer ${token}`
      }
    })
      .then(res => {
        return res.data
      })
      .catch(error => {
        console.error('Error updating mobiliari', error)
        throw error
      })
  }

  // Actualizar parcialmente un servicio de mobiliario y decoración
  patchMobiliari (id, mobiliariData) {
    const token = localStorage.getItem('token')
    return http.patch(`/api/v1/mobiliari_decoracio/${id}`, mobiliariData, {
      headers: {
        'Authorization': `Bearer ${token}`
      }
    })
      .then(res => {
        return res.data
      })
      .catch(error => {
        console.error('Error patching mobiliari', error)
        throw error
      })
  }

  // Eliminar un servicio de mobiliario y decoración
  deleteMobiliari (id) {
    const token = localStorage.getItem('token')
    return http.delete(`/api/v1/mobiliari_decoracio/${id}`, {
      headers: {
        'Authorization': `Bearer ${token}`
      }
    })
      .then(res => {
        return res.data
      })
      .catch(error => {
        console.error('Error deleting mobiliari', error)
        throw error
      })
  }

  // Filtrar servicios de mobiliario y decoración
  filterMobiliaris (params) {
    const queryParams = new URLSearchParams()
    if (params.service_type) queryParams.append('service_type', params.service_type)
    if (params.tipologia) {
      params.tipologia.forEach(tipo => {
        queryParams.append('tipologia', tipo)
      })
    }
    if (params.is_rental !== undefined) queryParams.append('is_rental', params.is_rental)
    if (params.cantidad) queryParams.append('cantidad', params.cantidad)
    if (params.material) {
      params.material.forEach(mat => {
        queryParams.append('material', mat)
      })
    }
    if (params.color) {
      params.color.forEach(col => {
        queryParams.append('color', col)
      })
    }
    if (params.caracteristicas) {
      params.caracteristicas.forEach(carac => {
        queryParams.append('caracteristicas', carac)
      })
    }
    if (params.forma) {
      params.forma.forEach(f => {
        queryParams.append('forma', f)
      })
    }
    if (params.skip) queryParams.append('skip', params.skip)
    if (params.limit) queryParams.append('limit', params.limit)

    return http.get(`/api/v1/mobiliari-decoracio/filter?${queryParams.toString()}`)
      .then(res => {
        return res.data
      })
      .catch(error => {
        console.error('Error filtering mobiliaris', error)
        throw error
      })
  }

  // Filtrar mis servicios de mobiliario y decoración
  filterMyMobiliaris (params) {
    const token = localStorage.getItem('token')
    const queryParams = new URLSearchParams()
    if (params.service_type) queryParams.append('service_type', params.service_type)
    if (params.tipologia) {
      params.tipologia.forEach(tipo => {
        queryParams.append('tipologia', tipo)
      })
    }
    if (params.is_rental !== undefined) queryParams.append('is_rental', params.is_rental)
    if (params.cantidad) queryParams.append('cantidad', params.cantidad)
    if (params.material) {
      params.material.forEach(mat => {
        queryParams.append('material', mat)
      })
    }
    if (params.color) {
      params.color.forEach(col => {
        queryParams.append('color', col)
      })
    }
    if (params.caracteristicas) {
      params.caracteristicas.forEach(carac => {
        queryParams.append('caracteristicas', carac)
      })
    }
    if (params.forma) {
      params.forma.forEach(f => {
        queryParams.append('forma', f)
      })
    }
    if (params.skip) queryParams.append('skip', params.skip)
    if (params.limit) queryParams.append('limit', params.limit)

    return http.get(`/api/v1/mobiliari-decoracio/filter_me?${queryParams.toString()}`, {
      headers: {
        'Authorization': `Bearer ${token}`
      }
    })
      .then(res => {
        return res.data
      })
      .catch(error => {
        console.error('Error filtering my mobiliaris', error)
        throw error
      })
  }
}

export default new MobiliariDecoracioService()
