import http from '@/http-common'

class MusicaService {
  // Obtener todos los servicios de música
  getAllMusicas (skip = 0, limit = 10) {
    return http.get(`/api/v1/musicas/all/?skip=${skip}&limit=${limit}`)
      .then(res => {
        return res.data
      })
      .catch(error => {
        console.error('Error fetching musicas', error)
        throw error
      })
  }

  // Obtener mis servicios de música
  getAllMyMusicas (skip = 0, limit = 10) {
    const token = localStorage.getItem('token')
    return http.get(`/api/v1/musicas/all_me/?skip=${skip}&limit=${limit}`, {
      headers: {
        'Authorization': `Bearer ${token}`
      }
    })
      .then(res => {
        return res.data
      })
      .catch(error => {
        console.error('Error fetching my musicas', error)
        throw error
      })
  }

  // Obtener un servicio de música por ID
  getMusicaById (id) {
    const token = localStorage.getItem('token')
    return http.get(`/api/v1/musica/by_id/${id}`, {
      headers: {
        'Authorization': `Bearer ${token}`
      }
    })
      .then(res => {
        return res.data
      })
      .catch(error => {
        console.error('Error fetching musica', error)
        throw error
      })
  }

  // Crear un nuevo servicio de música
  createMusica (musicaData) {
    const token = localStorage.getItem('token')
    return http.post('/api/v1/musica/', musicaData, {
      headers: {
        'Authorization': `Bearer ${token}`
      }
    })
      .then(res => {
        return res.data
      })
      .catch(error => {
        console.error('Error creating musica', error)
        throw error
      })
  }

  // Actualizar un servicio de música
  updateMusica (id, musicaData) {
    const token = localStorage.getItem('token')
    return http.put(`/api/v1/musica/${id}`, musicaData, {
      headers: {
        'Authorization': `Bearer ${token}`
      }
    })
      .then(res => {
        return res.data
      })
      .catch(error => {
        console.error('Error updating musica', error)
        throw error
      })
  }

  // Actualizar parcialmente un servicio de música
  patchMusica (id, musicaData) {
    const token = localStorage.getItem('token')
    return http.patch(`/api/v1/musicas/${id}`, musicaData, {
      headers: {
        'Authorization': `Bearer ${token}`
      }
    })
      .then(res => {
        return res.data
      })
      .catch(error => {
        console.error('Error patching musica', error)
        throw error
      })
  }

  // Eliminar un servicio de música
  deleteMusica (id) {
    const token = localStorage.getItem('token')
    return http.delete(`/api/v1/musicas/${id}`, {
      headers: {
        'Authorization': `Bearer ${token}`
      }
    })
      .then(res => {
        return res.data
      })
      .catch(error => {
        console.error('Error deleting musica', error)
        throw error
      })
  }

  // Filtrar servicios de música
  filterMusicas (params) {
    const queryParams = new URLSearchParams()
    if (params.musica_type) queryParams.append('musica_type', params.musica_type)
    if (params.genero) {
      params.genero.forEach(gen => {
        queryParams.append('genero', gen)
      })
    }
    if (params.canciones) queryParams.append('canciones', params.canciones)
    if (params.min_duracion) queryParams.append('min_duracion', params.min_duracion)
    if (params.max_duracion) queryParams.append('max_duracion', params.max_duracion)
    if (params.instrumento) {
      params.instrumento.forEach(inst => {
        queryParams.append('instrumento', inst)
      })
    }
    if (params.skip) queryParams.append('skip', params.skip)
    if (params.limit) queryParams.append('limit', params.limit)

    return http.get(`/api/v1/musicas/filter?${queryParams.toString()}`)
      .then(res => {
        return res.data
      })
      .catch(error => {
        console.error('Error filtering musicas', error)
        throw error
      })
  }

  // Filtrar mis servicios de música
  filterMyMusicas (params) {
    const token = localStorage.getItem('token')
    const queryParams = new URLSearchParams()
    if (params.musica_type) queryParams.append('musica_type', params.musica_type)
    if (params.genero) {
      params.genero.forEach(gen => {
        queryParams.append('genero', gen)
      })
    }
    if (params.canciones) queryParams.append('canciones', params.canciones)
    if (params.min_duracion) queryParams.append('min_duracion', params.min_duracion)
    if (params.max_duracion) queryParams.append('max_duracion', params.max_duracion)
    if (params.instrumento) {
      params.instrumento.forEach(inst => {
        queryParams.append('instrumento', inst)
      })
    }
    if (params.skip) queryParams.append('skip', params.skip)
    if (params.limit) queryParams.append('limit', params.limit)

    return http.get(`/api/v1/musicas/filter_me?${queryParams.toString()}`, {
      headers: {
        'Authorization': `Bearer ${token}`
      }
    })
      .then(res => {
        return res.data
      })
      .catch(error => {
        console.error('Error filtering my musicas', error)
        throw error
      })
  }
}

export default new MusicaService()
